/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.id.spi.PersistentNoSqlIdentifierGenerator;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultSchemaInitializationContext
implements SchemaDefiner.SchemaDefinitionContext {
    private final Database database;
    private final SessionFactoryImplementor factory;

    public DefaultSchemaInitializationContext(Database database, SessionFactoryImplementor factory) {
        this.database = database;
        this.factory = factory;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Set<EntityKeyMetadata> getAllEntityKeyMetadata() {
        HashSet<EntityKeyMetadata> allEntityKeyMetadata = new HashSet<EntityKeyMetadata>();
        for (EntityPersister entityPersister : this.factory.getEntityPersisters().values()) {
            allEntityKeyMetadata.add(((OgmEntityPersister)entityPersister).getEntityKeyMetadata());
        }
        return allEntityKeyMetadata;
    }

    @Override
    public Set<AssociationKeyMetadata> getAllAssociationKeyMetadata() {
        HashSet<AssociationKeyMetadata> allAssociationKeyMetadata = new HashSet<AssociationKeyMetadata>();
        for (CollectionPersister associationPersister : this.factory.getCollectionPersisters().values()) {
            allAssociationKeyMetadata.add(((OgmCollectionPersister)associationPersister).getAssociationKeyMetadata());
        }
        for (EntityPersister entityPersister : this.factory.getEntityPersisters().values()) {
            for (String property : entityPersister.getPropertyNames()) {
                AssociationKeyMetadata inverseOneToOneAssociationKeyMetadata = ((OgmEntityPersister)entityPersister).getInverseOneToOneAssociationKeyMetadata(property);
                if (inverseOneToOneAssociationKeyMetadata == null) continue;
                allAssociationKeyMetadata.add(inverseOneToOneAssociationKeyMetadata);
            }
        }
        return allAssociationKeyMetadata;
    }

    @Override
    public Set<IdSourceKeyMetadata> getAllIdSourceKeyMetadata() {
        HashSet<IdSourceKeyMetadata> allIdSourceKeyMetadata = new HashSet<IdSourceKeyMetadata>();
        for (PersistentNoSqlIdentifierGenerator generator : this.getPersistentGenerators()) {
            allIdSourceKeyMetadata.add(generator.getGeneratorKeyMetadata());
        }
        return allIdSourceKeyMetadata;
    }

    private Iterable<PersistentNoSqlIdentifierGenerator> getPersistentGenerators() {
        Map entityPersisters = this.factory.getEntityPersisters();
        HashSet<PersistentNoSqlIdentifierGenerator> persistentGenerators = new HashSet<PersistentNoSqlIdentifierGenerator>(entityPersisters.size());
        for (EntityPersister persister : entityPersisters.values()) {
            if (!(persister.getIdentifierGenerator() instanceof PersistentNoSqlIdentifierGenerator)) continue;
            persistentGenerators.add((PersistentNoSqlIdentifierGenerator)persister.getIdentifierGenerator());
        }
        return persistentGenerators;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.factory;
    }
}

