/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.emulated.impl;

import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinatorOwner;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransaction;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransactionAccess;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class EmulatedLocalTransactionCoordinatorBuilder
implements TransactionCoordinatorBuilder {
    private final TransactionCoordinatorBuilder delegate;

    public EmulatedLocalTransactionCoordinatorBuilder(TransactionCoordinatorBuilder delegate) {
        this.delegate = delegate;
    }

    public TransactionCoordinator buildTransactionCoordinator(TransactionCoordinatorOwner owner, TransactionCoordinatorBuilder.TransactionCoordinatorOptions options) {
        return this.delegate.buildTransactionCoordinator((TransactionCoordinatorOwner)new NoopJdbcResourceTransactionCoordinatorOwner(owner), options);
    }

    public boolean isJta() {
        return false;
    }

    public ConnectionReleaseMode getDefaultConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_TRANSACTION;
    }

    public ConnectionAcquisitionMode getDefaultConnectionAcquisitionMode() {
        return ConnectionAcquisitionMode.DEFAULT;
    }

    private static class NoopJdbcResourceTransaction
    implements JdbcResourceTransaction {
        private TransactionStatus status;

        private NoopJdbcResourceTransaction() {
        }

        public void begin() {
            this.status = TransactionStatus.ACTIVE;
        }

        public void commit() {
            this.status = TransactionStatus.NOT_ACTIVE;
        }

        public void rollback() {
            this.status = TransactionStatus.NOT_ACTIVE;
        }

        public TransactionStatus getStatus() {
            return this.status;
        }
    }

    private static class NoopJdbcResourceTransactionCoordinatorOwner
    extends ForwardingTransactionCoordinatorOwner
    implements JdbcResourceTransactionAccess {
        public NoopJdbcResourceTransactionCoordinatorOwner(TransactionCoordinatorOwner delegate) {
            super(delegate);
        }

        public JdbcResourceTransaction getResourceLocalTransaction() {
            return new NoopJdbcResourceTransaction();
        }
    }
}

