/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.jta.impl;

import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinator;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinatorBuilder;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionDriver;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;

public class RollbackOnCommitFailureJtaTransactionCoordinatorBuilder
extends ForwardingTransactionCoordinatorBuilder {
    public RollbackOnCommitFailureJtaTransactionCoordinatorBuilder(TransactionCoordinatorBuilder delegate) {
        super(delegate);
    }

    @Override
    public TransactionCoordinator buildTransactionCoordinator(TransactionCoordinatorOwner owner, TransactionCoordinatorBuilder.TransactionCoordinatorOptions options) {
        return new RollbackOnCommitTransactionCoordinator(super.buildTransactionCoordinator(owner, options));
    }

    private static class RollbackOnCommitFailureTransactionDriver
    extends ForwardingTransactionDriver {
        public RollbackOnCommitFailureTransactionDriver(TransactionCoordinator.TransactionDriver delegate) {
            super(delegate);
        }

        @Override
        public void commit() {
            try {
                super.commit();
            }
            catch (Exception e) {
                try {
                    this.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    private static class RollbackOnCommitTransactionCoordinator
    extends ForwardingTransactionCoordinator {
        public RollbackOnCommitTransactionCoordinator(TransactionCoordinator delegate) {
            super(delegate);
        }

        @Override
        public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
            return new RollbackOnCommitFailureTransactionDriver(super.getTransactionDriverControl());
        }
    }
}

