/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor.impl;

import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class AttributeConverterGridTypeDescriptorAdaptor
implements GridTypeDescriptor {
    private static final Log log = LoggerFactory.make();
    private final AttributeConverter converter;
    private final GridTypeDescriptor delegate;
    private final JavaTypeDescriptor intermediateJavaTypeDescriptor;

    public AttributeConverterGridTypeDescriptorAdaptor(AttributeConverter converter, GridType delegate, JavaTypeDescriptor intermediateJavaTypeDescriptor) {
        this.converter = converter;
        this.delegate = new GridTypeToGridTypeDescriptorAdapter(delegate);
        this.intermediateJavaTypeDescriptor = intermediateJavaTypeDescriptor;
    }

    @Override
    public <X> GridValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        final GridValueBinder realBinder = this.delegate.getBinder(this.intermediateJavaTypeDescriptor);
        return new GridValueBinder<X>(){

            @Override
            public void bind(Tuple resultset, X value, String[] names) {
                Object convertedValue;
                try {
                    convertedValue = AttributeConverterGridTypeDescriptorAdaptor.this.converter.convertToDatabaseColumn(value);
                }
                catch (PersistenceException pe) {
                    throw pe;
                }
                catch (RuntimeException re) {
                    throw new PersistenceException("Error attempting to apply AttributeConverter", (Throwable)re);
                }
                log.debugf("Converted value on binding : %s -> %s", value, convertedValue);
                try {
                    realBinder.bind(resultset, convertedValue, names);
                }
                catch (Exception e) {
                    throw log.failureWhenUsingAttributeConverter(AttributeConverterGridTypeDescriptorAdaptor.this.converter.getClass(), e);
                }
            }
        };
    }

    @Override
    public <X> GridValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        final GridValueExtractor realExtractor = this.delegate.getExtractor(this.intermediateJavaTypeDescriptor);
        return new GridValueExtractor<X>(){

            @Override
            public X extract(Tuple resultset, String name) {
                return this.doConversion(realExtractor.extract(resultset, name));
            }

            private X doConversion(Object extractedValue) {
                try {
                    Object convertedValue = AttributeConverterGridTypeDescriptorAdaptor.this.converter.convertToEntityAttribute(extractedValue);
                    log.debugf("Converted value on extraction: %s -> %s", extractedValue, convertedValue);
                    return convertedValue;
                }
                catch (PersistenceException pe) {
                    throw pe;
                }
                catch (RuntimeException re) {
                    throw log.failureWhenUsingAttributeConverter(AttributeConverterGridTypeDescriptorAdaptor.this.converter.getClass(), re);
                }
            }
        };
    }

    private static class GridTypeToGridTypeDescriptorAdapter
    implements GridTypeDescriptor {
        private final GridType gridType;

        public GridTypeToGridTypeDescriptorAdapter(GridType gridType) {
            this.gridType = gridType;
        }

        @Override
        public <X> GridValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new GridValueBinder<X>(){

                @Override
                public void bind(Tuple resultset, X value, String[] names) {
                    GridTypeToGridTypeDescriptorAdapter.this.gridType.nullSafeSet(resultset, value, names, null);
                }
            };
        }

        @Override
        public <X> GridValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new GridValueExtractor<X>(){

                @Override
                public X extract(Tuple resultset, String name) {
                    return GridTypeToGridTypeDescriptorAdapter.this.gridType.nullSafeGet(resultset, name, null, null);
                }
            };
        }
    }
}

