/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor.impl;

import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class ByteArrayMappedGridTypeDescriptor
implements GridTypeDescriptor {
    public static final ByteArrayMappedGridTypeDescriptor INSTANCE = new ByteArrayMappedGridTypeDescriptor();

    @Override
    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                resultset.put(names[0], javaTypeDescriptor.unwrap(value, byte[].class, options));
            }
        };
    }

    @Override
    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            @Override
            public X extract(Tuple resultset, String name) {
                byte[] result = (byte[])resultset.get(name);
                if (result == null) {
                    return null;
                }
                return javaTypeDescriptor.wrap((Object)result, null);
            }
        };
    }
}

