/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Collection;
import javax.persistence.PersistenceException;
import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransactionException;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.exception.EntityAlreadyExistsException;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.options.spi.AnnotationConverter;
import org.hibernate.ogm.util.impl.ClassObjectFormatter;
import org.hibernate.service.spi.ServiceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Hibernate OGM %1$s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s")
    public void persistenceXmlNotFoundInClassPath(String var1);

    @Message(id=11, value="Cannot instantiate GridDialect class [%1$s]")
    public HibernateException cannotInstantiateGridDialect(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=14, value="%1$s has no constructor accepting org.hibernate.ogm.datastore.spi.DatastoreProvider")
    public HibernateException gridDialectHasNoProperConstructor(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1);

    @Message(id=15, value="Expected DatastoreProvider %2$s but found %1$s")
    public HibernateException unexpectedDatastoreProvider(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @FormatWith(value=ClassObjectFormatter.class) Class<?> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="NoSQL Datastore provider: %1$s")
    public void useDatastoreProvider(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Grid Dialect: %1$s")
    public void useGridDialect(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1);

    @Message(id=18, value="JTA transaction begin failed")
    public TransactionException jtaTransactionBeginFailed(@Cause Exception var1);

    @Message(id=19, value="JTA transaction commit failed")
    public TransactionException jtaCommitFailed(@Cause Exception var1);

    @Message(id=20, value="JTA transaction rollback failed")
    public TransactionException jtaRollbackFailed(@Cause Exception var1);

    @Message(id=21, value="Unable to mark JTA transaction for rollback")
    public TransactionException unableToMarkTransactionForRollback(@Cause Exception var1);

    @Message(id=22, value="Could not determine transaction status")
    public TransactionException jtaCouldNotDetermineStatus(@Cause SystemException var1);

    @Message(id=23, value="Unable to set transaction timeout to '%1$s'")
    public TransactionException unableToSetTimeout(@Cause SystemException var1, int var2);

    @Message(id=24, value="Syntax error in query: [%1$s]")
    public HibernateException querySyntaxException(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Batch indexing was interrupted")
    public void interruptedBatchIndexing();

    @Message(id=26, value="Illegal discriminator type: '%1$s'")
    public HibernateException illegalDiscrimantorType(String var1);

    @Message(id=27, value="Could not convert string to discriminator object")
    public HibernateException unableToConvertStringToDiscriminator(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=28, value="Created query object '%2$s' from HQL/JP-QL query '%1$s'.")
    public void createdQuery(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=31, value="OgmMassIndexer doesn't support the configuration option '%s'. Its setting will be ignored.")
    public void unsupportedIndexerConfigurationOption(String var1);

    @Message(id=32, value="Unable to support mapping subtypes that are not interfaces: %1$s")
    public HibernateException mappingSubtypeNotInterface(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1);

    @Message(id=33, value="Unable to create new proxy instance")
    public HibernateException cannotCreateNewProxyInstance(@Cause Exception var1);

    @Message(id=34, value="Annotation cannot be converted using %1$s")
    public HibernateException cannotConvertAnnotation(@FormatWith(value=ClassObjectFormatter.class) Class<? extends AnnotationConverter<?>> var1, @Cause Exception var2);

    @Message(id=36, value="Unable to load %1$s method from %2$s ")
    public HibernateException unableToLoadContext(String var1, @FormatWith(value=ClassObjectFormatter.class) Class<?> var2, @Cause Exception var3);

    @Message(id=37, value="Unable to create global context proxy for type %1$s")
    public HibernateException cannotCreateGlobalContextProxy(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=38, value="Unable to create entity context proxy for type %1$s")
    public HibernateException cannotCreateEntityContextProxy(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=39, value="Unable to create property context proxy for type %1$s")
    public HibernateException cannotCreatePropertyContextProxy(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=41, value="The given propery %1$s#%2$s with element type %3$s does not exist.")
    public HibernateException getPropertyDoesNotExistException(String var1, String var2, ElementType var3);

    @Message(id=42, value="The given element type %1$s is neither FIELD nor METHOD.")
    public HibernateException getUnsupportedElementTypeException(ElementType var1);

    @Message(id=43, value="Cannot instantiate type %1$s. Does it define a default constructor?")
    public HibernateException unableToInstantiateType(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=44, value="Cannot load class %2$s specified via configuration property '%1$s'")
    public HibernateException unableToLoadClass(String var1, String var2, @Cause Exception var3);

    @Message(id=45, value="Type %2$s specified via configuration property '%1$s' is not a sub-type of expected type %3$s")
    public HibernateException unexpectedClassType(String var1, @FormatWith(value=ClassObjectFormatter.class) Class<?> var2, @FormatWith(value=ClassObjectFormatter.class) Class<?> var3);

    @Message(id=46, value="Object %2$s of type %3$s specified via configuration property '%1$s' is not of the expected type %4$s")
    public HibernateException unexpectedInstanceType(String var1, String var2, @FormatWith(value=ClassObjectFormatter.class) Class<?> var3, @FormatWith(value=ClassObjectFormatter.class) Class<?> var4);

    @Message(id=47, value="Either an option configurator may be specified via configuration property '%1$s' or OgmConfiguration#configureOptions() may be called, but not both at the same time.")
    public HibernateException ambigiousOptionConfiguration(String var1);

    @Message(id=48, value="Unknown association storage strategy: [%s]. Supported values are: %s")
    public HibernateException unknownAssociationStorageStrategy(String var1, String var2);

    @Message(id=49, value="The value set for the configuration property 'hibernate.ogm.datastore.port' must be a number between 1 and 65535. Found '%s'.")
    public HibernateException illegalPortValue(int var1);

    @Message(id=50, value="The value set for the configuration property '%1$s' must be an integer number. Found '%2$s'.")
    public HibernateException notAnInteger(String var1, String var2);

    @Message(id=51, value="Unknown value given for configuration property '%1$s'; Found '%2$s', but supported values are: %3$s")
    public HibernateException unknownEnumerationValue(String var1, String var2, String var3);

    @Message(id=52, value="Missing value for property '%s'")
    public HibernateException missingConfigurationProperty(String var1);

    @Message(id=53, value="Value of unsupported type given for configuration property '%1$s': '%2$s'")
    public HibernateException unsupportedPropertyType(String var1, String var2);

    @Message(id=54, value="It is not possible to add or poll operations from a closed queue")
    public HibernateException closedOperationQueue();

    @Message(id=55, value="Invalid URL given for configuration property '%1$s': %2$s; The specified resource could not be found.")
    public HibernateException invalidConfigurationUrl(String var1, String var2);

    @Message(id=56, value="Unable to load record for retrieval of generated properties; Entity type: %1$s, id: %2$s")
    public HibernateException couldNotRetrieveEntityForRetrievalOfGeneratedProperties(String var1, Serializable var2);

    @Message(id=57, value="'%s' must not be null")
    public IllegalArgumentException mustNotBeNull(String var1);

    @Message(id=58, value="Parameter '%s' must not be null")
    public IllegalArgumentException parameterMustNotBeNull(String var1);

    @Message(id=59, value="Unable to find a GridType for %s")
    public HibernateException unableToFindGridType(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=60, value="Sequence id generator used for entity '%2$s' is not supported by grid dialect %1$s, falling back to table-based id generation. Consider to use @TableGenerator rather than @SequenceGenerator.")
    public void dialectDoesNotSupportSequences(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=61, value="The option '@TableGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.")
    public void catalogOptionNotSupportedForTableGenerator(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=62, value="The option '@TableGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.")
    public void schemaOptionNotSupportedForTableGenerator(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=63, value="The option '@SequenceGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.")
    public void catalogOptionNotSupportedForSequenceGenerator(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=64, value="The option '@SequenceGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.")
    public void schemaOptionNotSupportedForSequenceGenerator(String var1);

    @Message(id=65, value="Id generation strategy IDENTITY configured for entity %1$s is not supported by the current grid dialect.")
    public HibernateException getIdentityGenerationStrategyNotSupportedException(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=66, value="Entity type %s uses an optimistic locking strategy which is not supported by the current grid dialect in an atomic manner. There will be two datastore round-trips for version checking and updating the data.")
    public void usingNonAtomicOptimisticLocking(String var1);

    @Message(id=67, value="Trying to insert an already existing entity: %s")
    public EntityAlreadyExistsException mustNotInsertSameEntityTwice(String var1, @Cause Exception var2);

    @Message(id=68, value="Could not configure property %1$s#%2$s")
    public HibernateException couldNotConfigureProperty(String var1, String var2, @Cause Exception var3);

    @Message(id=69, value="Grid dialect %1$s does not support lock mode %2$s")
    public HibernateException unsupportedLockMode(@FormatWith(value=ClassObjectFormatter.class) Class<? extends GridDialect> var1, LockMode var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=70, value="'%1$s' is no valid datastore provider short name. Valid values are: %2$s")
    public void noValidDatastoreProviderShortName(String var1, String var2);

    @Message(id=71, value="Unable to start datatore provider")
    public ServiceException unableToStartDatastoreProvider(@Cause Exception var1);

    @Message(id=72, value="Unable to configure datatore provider")
    public ServiceException unableToConfigureDatastoreProvider(@Cause Exception var1);

    @Message(id=73, value="Couldn't load the Lucene-based query parser backend. Make sure the dependency org.hibernate.hql:hibernate-hql-lucene is part of the classpath.")
    public HibernateException cannotLoadLuceneParserBackend(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=74, value="Could not close session; swallowing exception as transaction completed")
    public void unableToCloseSessionButSwallowingError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=75, value="JBoss Transaction Manager (com.arjuna.ats.jta.TransactionManager) detected on classpath. Using JBossStandAloneJtaPlatform as JTAPlatform implementation")
    public void jbossTransactionManagerDetected();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=76, value="No explicit or implicit defined JTAPlatform. Using NoJtaPlatform")
    public void noJtaPlatformDetected();

    @Message(id=77, value="Parameter '%s' must not be an empty string")
    public IllegalArgumentException parameterSringMustNotBeEmpty(String var1);

    @Message(id=78, value="Unrecognized alias in query:  %s")
    public HibernateException getUnknownAliasException(String var1);

    @Message(id=79, value="Unable to parse hibernate.ogm.datastore.host %s\nProperty should be a comma separated list of host:port\ne.g. www.example.com, www2.example.com:123, 192.0.2.1, 192.0.2.2:123, 2001:db8::ff00:42:8329, [2001:db8::ff00:42:8329]:123")
    public HibernateException unableToParseHost(String var1);

    @Message(id=80, value="Could not load an entity batch: %s")
    public HibernateException errorOnEntityBatchLoad(String var1, @Cause Exception var2);

    @Message(id=81, value="The value set for the configuration property '%1$s' must be a long number. Found '%2$s'.")
    public HibernateException notALong(String var1, String var2);

    @Message(id=82, value="The entity at the inverse side of the association '%1$s' cannot be found in the session: %2$s")
    public HibernateException entityTupleNotFound(String var1, EntityKey var2);

    @Message(id=83, value="Failure when using JPA AttributeConverter [%1$s]. Is the datastore type of the converter a supported type for your datastore?")
    public PersistenceException failureWhenUsingAttributeConverter(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=84, value="Unable to find basic type support for [%2$s] when using JPA AttributeConverter [%1$s].Is the datastore type of the converter a supported type for your datastore?")
    public PersistenceException cannotFindTypeForAttributeConverter(@FormatWith(value=ClassObjectFormatter.class) Class<?> var1, @FormatWith(value=ClassObjectFormatter.class) Class<?> var2);

    @Message(id=85, value="Unable to find an entity entry for the entity '%1$s'")
    public PersistenceException cannotFindEntityEntryForEntity(Object var1);

    @Message(id=89, value="%1$s does not support queries on polymorphic entities using TABLE_PER_CLASS inheritance strategy. You should try using SINGLE_TABLE instead. Entities: %2$s")
    public HibernateException queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass(String var1, Collection<String> var2);
}

