/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.manytomany;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.Tire;

@Entity
public class Car {
    private CarId carId;
    private Integer hp;
    private Set<Tire> tires = new HashSet<Tire>();

    @EmbeddedId
    public CarId getCarId() {
        return this.carId;
    }

    public void setCarId(CarId carId) {
        this.carId = carId;
    }

    public Integer getHp() {
        return this.hp;
    }

    public void setHp(Integer hp) {
        this.hp = hp;
    }

    @ManyToMany
    public Set<Tire> getTires() {
        return this.tires;
    }

    public void setTires(Set<Tire> tires) {
        this.tires = tires;
    }

    public static class CarId
    implements Serializable {
        private String maker;
        private String model;

        public CarId() {
        }

        public CarId(String maker, String model) {
            this.maker = maker;
            this.model = model;
        }

        public String getMaker() {
            return this.maker;
        }

        public void setMaker(String maker) {
            this.maker = maker;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.maker == null ? 0 : this.maker.hashCode());
            result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CarId other = (CarId)obj;
            if (this.maker == null) {
                if (other.maker != null) {
                    return false;
                }
            } else {
                if (!this.maker.equals(other.maker)) {
                    return false;
                }
                if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
                    return false;
                }
            }
            return true;
        }
    }
}

