/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.manytomany;

import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.ClassRoom;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.Student;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="Classroom.students list - bag semantics unsupported (no primary key)")
public class ManyToManyExtraTest
extends OgmTestCase {
    @Test
    public void testUnidirectionalManyToMany() {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Student john = new Student("john", "John Doe");
        Student kate = new Student("kate", "Kate Doe");
        Student mario = new Student("mario", "Mario Rossi");
        ClassRoom math = new ClassRoom(1L, "Math");
        math.getStudents().add(john);
        math.getStudents().add(mario);
        ClassRoom english = new ClassRoom(2L, "English");
        english.getStudents().add(kate);
        english.getStudents().add(mario);
        this.persist((Session)session, math, english, john, mario, kate);
        tx.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(5L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo(2L);
        session.clear();
        this.delete((Session)session, math, english, john, mario, kate);
        session.close();
        this.checkCleanCache();
    }

    private void persist(Session session, Object ... entities) {
        for (Object entity : entities) {
            session.persist(entity);
        }
    }

    private void delete(Session session, Object ... entities) {
        Transaction transaction = session.beginTransaction();
        for (Object entity : entities) {
            session.delete(entity);
        }
        transaction.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Student.class, ClassRoom.class};
    }
}

