/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.manytomany;

import java.io.Serializable;
import java.util.EnumSet;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.AccountOwner;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.BankAccount;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.Car;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.Tire;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Test;

public class ManyToManyTest
extends OgmTestCase {
    @Test
    public void testBidirectionalManyToMany() {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        AccountOwner owner = new AccountOwner("owner_1");
        owner.setSSN("0123456");
        BankAccount soge = new BankAccount("account_1");
        soge.setAccountNumber("X2345000");
        owner.getBankAccounts().add(soge);
        soge.getOwners().add(owner);
        session.persist((Object)owner);
        tx.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(2L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo((long)this.expectedAssociationNumber());
        session.clear();
        tx = session.beginTransaction();
        soge = TestHelper.get((Session)session, BankAccount.class, (Serializable)((Object)soge.getId()));
        Assertions.assertThat(soge.getOwners()).hasSize(1);
        Assertions.assertThat(soge.getOwners()).onProperty("id").contains(new Object[]{owner.getId()});
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        owner = TestHelper.get((Session)session, AccountOwner.class, (Serializable)((Object)owner.getId()));
        Assertions.assertThat(owner.getBankAccounts()).hasSize(1);
        Assertions.assertThat(owner.getBankAccounts()).onProperty("id").contains(new Object[]{soge.getId()});
        BankAccount barclays = new BankAccount("account_2");
        barclays.setAccountNumber("ZZZ-009");
        barclays.getOwners().add(owner);
        soge = owner.getBankAccounts().iterator().next();
        soge.getOwners().remove(owner);
        owner.getBankAccounts().add(barclays);
        owner.getBankAccounts().remove(soge);
        session.delete((Object)soge);
        tx.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(2L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo((long)this.expectedAssociationNumber());
        session.clear();
        tx = session.beginTransaction();
        owner = TestHelper.get((Session)session, AccountOwner.class, (Serializable)((Object)owner.getId()));
        Assertions.assertThat(owner.getBankAccounts()).hasSize(1);
        Assertions.assertThat(owner.getBankAccounts()).onProperty("id").contains(new Object[]{barclays.getId()});
        barclays = owner.getBankAccounts().iterator().next();
        barclays.getOwners().clear();
        owner.getBankAccounts().clear();
        session.delete((Object)barclays);
        session.delete((Object)owner);
        tx.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(0L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo(0L);
        session.close();
        this.checkCleanCache();
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.CASSANDRA}, comment="composite PKs in associations not yet supported")
    public void testManyToManyCompositeId() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Car car = new Car();
        car.setCarId(new Car.CarId("Citroen", "AX"));
        car.setHp(20);
        session.persist((Object)car);
        Tire tire = new Tire();
        tire.setTireId(new Tire.TireId("Michelin", "B1"));
        tire.setSize(17.0);
        car.getTires().add(tire);
        tire.getCars().add(car);
        session.persist((Object)tire);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        car = (Car)session.get(Car.class, (Serializable)car.getCarId());
        Assertions.assertThat(car.getTires()).hasSize(1);
        Assertions.assertThat(car.getTires().iterator().next().getCars()).contains(new Object[]{car});
        session.delete((Object)car);
        session.delete((Object)car.getTires().iterator().next());
        transaction.commit();
        session.close();
    }

    private int expectedAssociationNumber() {
        if (EnumSet.of(GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE).contains((Object)TestHelper.getCurrentDialectType())) {
            return 1;
        }
        return 2;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{AccountOwner.class, BankAccount.class, Car.class, Tire.class};
    }
}

