/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.manytomany;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import org.hibernate.ogm.backendtck.associations.collection.manytomany.Car;

@Entity
public class Tire {
    private TireId tireId;
    private Double size;
    private Set<Car> cars = new HashSet<Car>();

    @EmbeddedId
    public TireId getTireId() {
        return this.tireId;
    }

    public void setTireId(TireId tireId) {
        this.tireId = tireId;
    }

    public Double getSize() {
        return this.size;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    @ManyToMany(mappedBy="tires")
    public Set<Car> getCars() {
        return this.cars;
    }

    public void setCars(Set<Car> cars) {
        this.cars = cars;
    }

    public static class TireId
    implements Serializable {
        private String maker;
        private String model;

        public TireId() {
        }

        public TireId(String maker, String model) {
            this.maker = maker;
            this.model = model;
        }

        public String getMaker() {
            return this.maker;
        }

        public void setMaker(String maker) {
            this.maker = maker;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.maker == null ? 0 : this.maker.hashCode());
            result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TireId other = (TireId)obj;
            if (this.maker == null) {
                if (other.maker != null) {
                    return false;
                }
            } else {
                if (!this.maker.equals(other.maker)) {
                    return false;
                }
                if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
                    return false;
                }
            }
            return true;
        }
    }
}

