/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.types;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.types.Child;
import org.hibernate.ogm.backendtck.associations.collection.types.Father;
import org.hibernate.ogm.backendtck.associations.collection.types.GrandChild;
import org.hibernate.ogm.backendtck.associations.collection.types.GrandMother;
import org.hibernate.ogm.backendtck.associations.collection.types.Race;
import org.hibernate.ogm.backendtck.associations.collection.types.Runner;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Test;

public class ListTest
extends OgmTestCase {
    @Test
    public void testOrderedList() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Child luke = new Child();
        luke.setName("Luke");
        Child leia = new Child();
        leia.setName("Leia");
        session.persist((Object)luke);
        session.persist((Object)leia);
        Father father = new Father();
        father.getOrderedChildren().add(luke);
        father.getOrderedChildren().add(null);
        father.getOrderedChildren().add(leia);
        session.persist((Object)father);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        father = (Father)session.get(Father.class, (Serializable)((Object)father.getId()));
        ((ListAssert)Assertions.assertThat(father.getOrderedChildren()).as("List should have 3 elements")).hasSize(3);
        ((StringAssert)Assertions.assertThat((String)father.getOrderedChildren().get(0).getName()).as("Luke should be first")).isEqualTo((Object)luke.getName());
        ((ObjectAssert)Assertions.assertThat((Object)father.getOrderedChildren().get(1)).as("Second born should be null")).isNull();
        ((StringAssert)Assertions.assertThat((String)father.getOrderedChildren().get(2).getName()).as("Leia should be third")).isEqualTo((Object)leia.getName());
        session.delete((Object)father);
        session.delete(session.load(Child.class, (Serializable)((Object)luke.getId())));
        session.delete(session.load(Child.class, (Serializable)((Object)leia.getId())));
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testUpdateToElementOfOrderedListIsApplied() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        GrandChild luke = new GrandChild();
        luke.setName("Luke");
        GrandChild leia = new GrandChild();
        leia.setName("Leia");
        GrandMother grandMother = new GrandMother();
        grandMother.getGrandChildren().add(luke);
        grandMother.getGrandChildren().add(leia);
        session.persist((Object)grandMother);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        grandMother = (GrandMother)session.get(GrandMother.class, (Serializable)((Object)grandMother.getId()));
        Assertions.assertThat(grandMother.getGrandChildren()).onProperty("name").containsExactly(new Object[]{"Luke", "Leia"});
        grandMother.getGrandChildren().get(0).setName("Lisa");
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        grandMother = (GrandMother)session.get(GrandMother.class, (Serializable)((Object)grandMother.getId()));
        Assertions.assertThat(grandMother.getGrandChildren()).onProperty("name").containsExactly(new Object[]{"Lisa", "Leia"});
        session.delete((Object)grandMother);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testRemovalOfElementFromOrderedListIsApplied() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        GrandChild luke = new GrandChild();
        luke.setName("Luke");
        GrandChild leia = new GrandChild();
        leia.setName("Leia");
        GrandMother grandMother = new GrandMother();
        grandMother.getGrandChildren().add(luke);
        grandMother.getGrandChildren().add(leia);
        session.persist((Object)grandMother);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        grandMother = (GrandMother)session.get(GrandMother.class, (Serializable)((Object)grandMother.getId()));
        grandMother.getGrandChildren().remove(0);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        grandMother = (GrandMother)session.get(GrandMother.class, (Serializable)((Object)grandMother.getId()));
        Assertions.assertThat(grandMother.getGrandChildren()).onProperty("name").containsExactly(new Object[]{"Leia"});
        session.delete((Object)grandMother);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testOrderedListAndCompositeId() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Race race = new Race();
        race.setRaceId(new Race.RaceId(23, 75));
        Runner runner = new Runner();
        runner.setAge(37);
        runner.setRunnerId(new Runner.RunnerId("Emmanuel", "Bernard"));
        Runner runner2 = new Runner();
        runner2.setAge(105);
        runner2.setRunnerId(new Runner.RunnerId("Pere", "Noel"));
        race.getRunnersByArrival().add(runner);
        race.getRunnersByArrival().add(runner2);
        session.persist((Object)race);
        session.persist((Object)runner);
        session.persist((Object)runner2);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        race = (Race)session.get(Race.class, (Serializable)race.getRaceId());
        Assertions.assertThat(race.getRunnersByArrival()).hasSize(2);
        Assertions.assertThat((String)race.getRunnersByArrival().get(0).getRunnerId().getFirstname()).isEqualTo((Object)"Emmanuel");
        session.delete((Object)race.getRunnersByArrival().get(0));
        session.delete((Object)race.getRunnersByArrival().get(1));
        session.delete((Object)race);
        transaction.commit();
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Father.class, GrandMother.class, Child.class, Race.class, Runner.class};
    }
}

