/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.types;

import java.io.Serializable;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.LongAssert;
import org.fest.assertions.MapAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.types.Address;
import org.hibernate.ogm.backendtck.associations.collection.types.PhoneNumber;
import org.hibernate.ogm.backendtck.associations.collection.types.User;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE, GridDialectType.CASSANDRA, GridDialectType.REDIS_HASH}, comment="Only the document stores CouchDB and MongoDB and Redis JSON support the configuration of specific association storage strategies")
public class MapContentsStoredInSeparateDocumentTest
extends OgmTestCase {
    @Test
    public void testMapAndElementCollection() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Address home = new Address();
        home.setCity("Paris");
        Address work = new Address();
        work.setCity("San Francisco");
        User user = new User();
        user.getAddresses().put("home", home);
        user.getAddresses().put("work", work);
        user.getNicknames().add("idrA");
        user.getNicknames().add("day[9]");
        session.persist((Object)home);
        session.persist((Object)work);
        session.persist((Object)user);
        User user2 = new User();
        user2.getNicknames().add("idrA");
        user2.getNicknames().add("day[9]");
        session.persist((Object)user2);
        tx.commit();
        session.clear();
        ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory, AssociationStorageType.IN_ENTITY)).describedAs("Element collection contents should be stored within the entity document")).isEqualTo(2L);
        ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory, AssociationStorageType.ASSOCIATION_DOCUMENT)).describedAs("Map contents should be stored in association document")).isEqualTo(1L);
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        ((CollectionAssert)Assertions.assertThat(user.getNicknames()).as("Should have 2 nick1")).hasSize(2);
        ((CollectionAssert)Assertions.assertThat(user.getNicknames()).as("Should contain nicks")).contains(new Object[]{"idrA", "day[9]"});
        user.getNicknames().remove("idrA");
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        ((MapAssert)Assertions.assertThat(user.getAddresses()).as("List should have 2 elements")).hasSize(2);
        ((StringAssert)Assertions.assertThat((String)user.getAddresses().get("home").getCity()).as("home address should be under home")).isEqualTo((Object)home.getCity());
        ((CollectionAssert)Assertions.assertThat(user.getNicknames()).as("Should have 1 nick1")).hasSize(1);
        ((CollectionAssert)Assertions.assertThat(user.getNicknames()).as("Should contain nick")).contains(new Object[]{"day[9]"});
        session.delete((Object)user);
        session.delete(session.load(Address.class, (Serializable)((Object)home.getId())));
        session.delete(session.load(Address.class, (Serializable)((Object)work.getId())));
        user2 = (User)session.get(User.class, (Serializable)((Object)user2.getId()));
        ((CollectionAssert)Assertions.assertThat(user2.getNicknames()).as("Should have 2 nicks")).hasSize(2);
        ((CollectionAssert)Assertions.assertThat(user2.getNicknames()).as("Should contain nick")).contains(new Object[]{"idrA", "day[9]"});
        session.delete((Object)user2);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{User.class, Address.class, PhoneNumber.class};
    }

    @Override
    protected void configure(Map<String, Object> settings) {
        settings.put("hibernate.ogm.datastore.document.association_storage", AssociationStorageType.ASSOCIATION_DOCUMENT);
    }
}

