/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.types;

import java.io.Serializable;
import java.util.HashMap;
import org.fest.assertions.Assertions;
import org.fest.assertions.LongAssert;
import org.fest.assertions.MapAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.types.Address;
import org.hibernate.ogm.backendtck.associations.collection.types.Department;
import org.hibernate.ogm.backendtck.associations.collection.types.Enterprise;
import org.hibernate.ogm.backendtck.associations.collection.types.PhoneNumber;
import org.hibernate.ogm.backendtck.associations.collection.types.User;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="hibernate core doesn't supply required primary key metadata for collections")
public class MapTest
extends OgmTestCase {
    @Test
    public void testMapOfEntity() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Address home = new Address();
        home.setCity("Paris");
        Address work = new Address();
        work.setCity("San Francisco");
        User user = new User();
        user.getAddresses().put("home", home);
        user.getAddresses().put("work", work);
        session.persist((Object)home);
        session.persist((Object)work);
        session.persist((Object)user);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        ((MapAssert)Assertions.assertThat(user.getAddresses()).as("Map should have 2 elements")).hasSize(2);
        ((StringAssert)Assertions.assertThat((String)user.getAddresses().get("home").getCity()).as("home address should be under home")).isEqualTo((Object)home.getCity());
        session.delete((Object)user);
        session.delete(session.load(Address.class, (Serializable)((Object)home.getId())));
        session.delete(session.load(Address.class, (Serializable)((Object)work.getId())));
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testSetElementCollectionStorageAndRemoval() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        User user = new User();
        user.getNicknames().add("idrA");
        user.getNicknames().add("day[9]");
        session.persist((Object)user);
        User user2 = new User();
        user2.getNicknames().add("idrA");
        user2.getNicknames().add("day[9]");
        session.persist((Object)user2);
        tx.commit();
        session.clear();
        if (TestHelper.getCurrentDialectType().isDocumentStore()) {
            ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory, AssociationStorageType.IN_ENTITY)).describedAs("Element collections should be stored within the entity document")).isEqualTo(2L);
            ((LongAssert)Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory, AssociationStorageType.ASSOCIATION_DOCUMENT)).describedAs("Element collections should be stored within the entity document")).isEqualTo(0L);
        }
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        Assertions.assertThat(user.getNicknames()).containsOnly(new Object[]{"idrA", "day[9]"});
        user.getNicknames().remove("idrA");
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        Assertions.assertThat(user.getNicknames()).containsOnly(new Object[]{"day[9]"});
        session.delete((Object)user);
        user2 = (User)session.get(User.class, (Serializable)((Object)user2.getId()));
        Assertions.assertThat(user2.getNicknames()).containsOnly(new Object[]{"idrA", "day[9]"});
        session.delete((Object)user2);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testRemovalOfMapEntry() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Address home = new Address();
        home.setCity("Paris");
        Address work = new Address();
        work.setCity("San Francisco");
        User user = new User();
        user.getAddresses().put("home", home);
        user.getAddresses().put("work", work);
        session.persist((Object)home);
        session.persist((Object)work);
        session.persist((Object)user);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        user.getAddresses().remove("work");
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        Assertions.assertThat(user.getAddresses()).hasSize(1);
        Assertions.assertThat((boolean)user.getAddresses().containsKey("home")).isTrue();
        Assertions.assertThat((String)user.getAddresses().get("home").getCity()).isEqualTo((Object)home.getCity());
        session.delete((Object)user);
        session.delete(session.load(Address.class, (Serializable)((Object)home.getId())));
        session.delete(session.load(Address.class, (Serializable)((Object)work.getId())));
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testMapOfEntityWithCompositeId() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        PhoneNumber home = new PhoneNumber(new PhoneNumber.PhoneNumberId("DE", 123), "Home Phone");
        PhoneNumber work = new PhoneNumber(new PhoneNumber.PhoneNumberId("EN", 456), "Work Phone");
        User user = new User();
        user.getPhoneNumbers().put("home", home);
        user.getPhoneNumbers().put("work", work);
        session.persist((Object)home);
        session.persist((Object)work);
        session.persist((Object)user);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        Assertions.assertThat((Object)user.getPhoneNumbers().get("home")).isNotNull();
        Assertions.assertThat((Object)user.getPhoneNumbers().get("home").getId()).isEqualTo((Object)new PhoneNumber.PhoneNumberId("DE", 123));
        Assertions.assertThat((Object)user.getPhoneNumbers().get("work")).isNotNull();
        Assertions.assertThat((Object)user.getPhoneNumbers().get("work").getId()).isEqualTo((Object)new PhoneNumber.PhoneNumberId("EN", 456));
        Assertions.assertThat(user.getPhoneNumbers()).hasSize(2);
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        session.delete((Object)user);
        session.delete(session.load(PhoneNumber.class, (Serializable)home.getId()));
        session.delete(session.load(PhoneNumber.class, (Serializable)work.getId()));
        tx.commit();
        session.close();
    }

    public void testMapOfComponent() {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        HashMap<String, Department> departments = new HashMap<String, Department>();
        departments.put("sawing", new Department("Sawing", 7));
        departments.put("sale", new Department("Sale", 2));
        Enterprise timberTradingInc = new Enterprise("enterprise-1", departments);
        session.persist((Object)timberTradingInc);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        timberTradingInc = (Enterprise)session.get(Enterprise.class, (Serializable)((Object)"enterprise-1"));
        Assertions.assertThat(timberTradingInc.getDepartments()).hasSize(2);
        Assertions.assertThat(timberTradingInc.getDepartments()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"sawing", (Object)new Department("Sawing", 7))});
        Assertions.assertThat(timberTradingInc.getDepartments()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"sale", (Object)new Department("Sale", 2))});
        session.delete((Object)timberTradingInc);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testMapWithSimpleValueType() {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Enterprise timberTradingInc = new Enterprise("enterprise-1", null);
        timberTradingInc.getRevenueByDepartment().put("sale", 1000);
        timberTradingInc.getRevenueByDepartment().put("sawing", 2000);
        timberTradingInc.getRevenueByDepartment().put("planting", 3000);
        session.persist((Object)timberTradingInc);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        timberTradingInc = (Enterprise)session.get(Enterprise.class, (Serializable)((Object)"enterprise-1"));
        Assertions.assertThat(timberTradingInc.getRevenueByDepartment()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"sawing", (Object)2000)});
        Assertions.assertThat(timberTradingInc.getRevenueByDepartment()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"sale", (Object)1000)});
        Assertions.assertThat(timberTradingInc.getRevenueByDepartment()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"planting", (Object)3000)});
        Assertions.assertThat(timberTradingInc.getRevenueByDepartment()).hasSize(3);
        session.delete((Object)timberTradingInc);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testMapWithStringKeyButListStyleEnforced() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        PhoneNumber home = new PhoneNumber(new PhoneNumber.PhoneNumberId("DE", 123), "Home Phone");
        PhoneNumber work = new PhoneNumber(new PhoneNumber.PhoneNumberId("EN", 456), "Work Phone");
        User user = new User();
        user.getAlternativePhoneNumbers().put("home", home);
        user.getAlternativePhoneNumbers().put("work", work);
        session.persist((Object)home);
        session.persist((Object)work);
        session.persist((Object)user);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        Assertions.assertThat((Object)user.getAlternativePhoneNumbers().get("home")).isNotNull();
        Assertions.assertThat((Object)user.getAlternativePhoneNumbers().get("home").getId()).isEqualTo((Object)new PhoneNumber.PhoneNumberId("DE", 123));
        Assertions.assertThat((Object)user.getAlternativePhoneNumbers().get("work")).isNotNull();
        Assertions.assertThat((Object)user.getAlternativePhoneNumbers().get("work").getId()).isEqualTo((Object)new PhoneNumber.PhoneNumberId("EN", 456));
        Assertions.assertThat(user.getAlternativePhoneNumbers()).hasSize(2);
        user = (User)session.get(User.class, (Serializable)((Object)user.getId()));
        session.delete((Object)user);
        session.delete(session.load(PhoneNumber.class, (Serializable)home.getId()));
        session.delete(session.load(PhoneNumber.class, (Serializable)work.getId()));
        tx.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{User.class, Address.class, PhoneNumber.class, Enterprise.class};
    }
}

