/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.types;

import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;

@Entity
public class PhoneNumber {
    @EmbeddedId
    private PhoneNumberId id;
    private String description;

    public PhoneNumber() {
    }

    public PhoneNumber(PhoneNumberId id, String description) {
        this.id = id;
        this.description = description;
    }

    public PhoneNumberId getId() {
        return this.id;
    }

    public void setId(PhoneNumberId id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Embeddable
    public static class PhoneNumberId
    implements Serializable {
        private String countryCode;
        private int number;

        public PhoneNumberId() {
        }

        public PhoneNumberId(String countryCode, int number) {
            this.countryCode = countryCode;
            this.number = number;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.countryCode == null ? 0 : this.countryCode.hashCode());
            result = 31 * result + this.number;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PhoneNumberId other = (PhoneNumberId)obj;
            if (this.countryCode == null ? other.countryCode != null : !this.countryCode.equals(other.countryCode)) {
                return false;
            }
            return this.number == other.number;
        }

        public String toString() {
            return "PhoneNumberId [countryCode=" + this.countryCode + ", number=" + this.number + "]";
        }
    }
}

