/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import org.hibernate.ogm.backendtck.associations.collection.types.Runner;

@Entity
public class Race {
    @EmbeddedId
    private RaceId raceId;
    @OrderColumn(name="ranking")
    @OneToMany
    @JoinTable(name="Race_Runners")
    private List<Runner> runnersByArrival = new ArrayList<Runner>();

    public RaceId getRaceId() {
        return this.raceId;
    }

    public void setRaceId(RaceId raceId) {
        this.raceId = raceId;
    }

    public List<Runner> getRunnersByArrival() {
        return this.runnersByArrival;
    }

    public void setRunnersByArrival(List<Runner> runnersByArrival) {
        this.runnersByArrival = runnersByArrival;
    }

    public static class RaceId
    implements Serializable {
        private int federationSequence;
        private int federationDepartment;

        public RaceId() {
        }

        public RaceId(int federationSequence, int federationDepartment) {
            this.federationSequence = federationSequence;
            this.federationDepartment = federationDepartment;
        }

        public int getFederationSequence() {
            return this.federationSequence;
        }

        public void setFederationSequence(int federationSequence) {
            this.federationSequence = federationSequence;
        }

        public int getFederationDepartment() {
            return this.federationDepartment;
        }

        public void setFederationDepartment(int federationDepartment) {
            this.federationDepartment = federationDepartment;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.federationDepartment;
            result = 31 * result + this.federationSequence;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RaceId other = (RaceId)obj;
            if (this.federationDepartment != other.federationDepartment) {
                return false;
            }
            return this.federationSequence == other.federationSequence;
        }
    }
}

