/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.types;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.ogm.backendtck.associations.collection.types.Address;
import org.hibernate.ogm.backendtck.associations.collection.types.PhoneNumber;
import org.hibernate.ogm.datastore.document.options.MapStorage;
import org.hibernate.ogm.datastore.document.options.MapStorageType;

@Entity
public class User {
    private String id;
    private Map<String, Address> addresses = new HashMap<String, Address>();
    private Map<String, PhoneNumber> phoneNumbers = new HashMap<String, PhoneNumber>();
    private Map<Integer, PhoneNumber> phoneNumbersByPriority = new HashMap<Integer, PhoneNumber>();
    private Map<String, PhoneNumber> alternativePhoneNumbers = new HashMap<String, PhoneNumber>();
    private Set<String> nicknames = new HashSet<String>();

    @Id
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @OneToMany
    @JoinTable(name="User_Address")
    @MapKeyColumn(name="addressType")
    public Map<String, Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Map<String, Address> addresses) {
        this.addresses = addresses;
    }

    @OneToMany
    public Map<String, PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(Map<String, PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    @OneToMany
    @MapStorage(value=MapStorageType.AS_LIST)
    @MapKeyColumn(name="phoneType")
    @JoinTable(name="AlTERNATIVE_PHONE_NUMBER")
    public Map<String, PhoneNumber> getAlternativePhoneNumbers() {
        return this.alternativePhoneNumbers;
    }

    public void setAlternativePhoneNumbers(Map<String, PhoneNumber> alternativePhoneNumbers) {
        this.alternativePhoneNumbers = alternativePhoneNumbers;
    }

    @OneToMany
    @MapKeyColumn(name="priority")
    @JoinTable(name="AlTERNATIVE_PRIORITY")
    public Map<Integer, PhoneNumber> getPhoneNumbersByPriority() {
        return this.phoneNumbersByPriority;
    }

    public void setPhoneNumbersByPriority(Map<Integer, PhoneNumber> phoneNumbersByPriority) {
        this.phoneNumbersByPriority = phoneNumbersByPriority;
    }

    @ElementCollection
    @JoinTable(name="Nicks", joinColumns={@JoinColumn(name="user_id")})
    public Set<String> getNicknames() {
        return this.nicknames;
    }

    public void setNicknames(Set<String> nicknames) {
        this.nicknames = nicknames;
    }
}

