/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.collection.unidirectional;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.Cloud;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.SnowFlake;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class CollectionUnidirectionalTest
extends OgmTestCase {
    @Test
    public void testUnidirectionalCollection() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        SnowFlake sf = new SnowFlake();
        sf.setDescription("Snowflake 1");
        session.save((Object)sf);
        SnowFlake sf2 = new SnowFlake();
        sf2.setDescription("Snowflake 2");
        session.save((Object)sf2);
        Cloud cloud = new Cloud();
        cloud.setLength(23.0);
        cloud.getProducedSnowFlakes().add(sf);
        cloud.getProducedSnowFlakes().add(sf2);
        session.persist((Object)cloud);
        session.flush();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((Session)session)).isEqualTo(3L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((Session)session)).isEqualTo(1L);
        transaction.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(3L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo(1L);
        session.clear();
        transaction = session.beginTransaction();
        cloud = (Cloud)session.get(Cloud.class, (Serializable)((Object)cloud.getId()));
        Assert.assertNotNull(cloud.getProducedSnowFlakes());
        Assert.assertEquals((long)2L, (long)cloud.getProducedSnowFlakes().size());
        SnowFlake removedSf = cloud.getProducedSnowFlakes().iterator().next();
        SnowFlake sf3 = new SnowFlake();
        sf3.setDescription("Snowflake 3");
        session.persist((Object)sf3);
        cloud.getProducedSnowFlakes().remove(removedSf);
        cloud.getProducedSnowFlakes().add(sf3);
        transaction.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(4L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo(1L);
        session.clear();
        transaction = session.beginTransaction();
        cloud = (Cloud)session.get(Cloud.class, (Serializable)((Object)cloud.getId()));
        Assert.assertNotNull(cloud.getProducedSnowFlakes());
        Assert.assertEquals((long)2L, (long)cloud.getProducedSnowFlakes().size());
        boolean present = false;
        for (SnowFlake current : cloud.getProducedSnowFlakes()) {
            if (!current.getDescription().equals(removedSf.getDescription())) continue;
            present = true;
        }
        Assert.assertFalse((String)"flake not removed", (boolean)present);
        for (SnowFlake current : cloud.getProducedSnowFlakes()) {
            session.delete((Object)current);
        }
        session.delete(session.load(SnowFlake.class, (Serializable)((Object)removedSf.getId())));
        cloud.getProducedSnowFlakes().clear();
        transaction.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(1L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo(0L);
        session.clear();
        transaction = session.beginTransaction();
        cloud = (Cloud)session.get(Cloud.class, (Serializable)((Object)cloud.getId()));
        Assert.assertNotNull(cloud.getProducedSnowFlakes());
        Assert.assertEquals((long)0L, (long)cloud.getProducedSnowFlakes().size());
        session.delete((Object)cloud);
        session.flush();
        transaction.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(0L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo(0L);
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Cloud.class, SnowFlake.class};
    }
}

