/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.compositeid;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.compositeid.Director;
import org.hibernate.ogm.backendtck.associations.compositeid.Tournament;
import org.hibernate.ogm.backendtck.associations.compositeid.TournamentId;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="Director.Tournament list - bag semantics unsupported (no primary key)")
public class ReferencedCompositeIdTest
extends OgmTestCase {
    @Test
    public void testManyToOneReferenceWithCompositeId() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Tournament britishOpen = new Tournament(new TournamentId("US", "123"), "British Open");
        Tournament playersChampionship = new Tournament(new TournamentId("US", "456"), "Player's Championship");
        session.persist((Object)britishOpen);
        session.persist((Object)playersChampionship);
        Director bob = new Director("bob", "Bob", playersChampionship);
        session.persist((Object)bob);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Director loadedParticipant = (Director)session.get(Director.class, (Serializable)((Object)"bob"));
        Assertions.assertThat((String)bob.getDirectedTournament().getName()).isEqualTo((Object)"Player's Championship");
        bob.setDirectedTournament(null);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedParticipant = (Director)session.get(Director.class, (Serializable)((Object)"bob"));
        Assertions.assertThat((Object)bob.getDirectedTournament()).isNull();
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedParticipant = (Director)session.get(Director.class, (Serializable)((Object)"bob"));
        session.delete((Object)loadedParticipant.getDirectedTournament());
        session.delete((Object)loadedParticipant);
        session.delete(session.get(Tournament.class, (Serializable)britishOpen.getId()));
        transaction.commit();
    }

    @Test
    public void testManyToManyReferenceWithCompositeId() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Tournament britishOpen = new Tournament(new TournamentId("US", "123"), "British Open");
        Tournament playersChampionship = new Tournament(new TournamentId("US", "456"), "Player's Championship");
        session.persist((Object)britishOpen);
        session.persist((Object)playersChampionship);
        Director bob = new Director("bob", "Bob", null);
        bob.getAttendedTournaments().add(britishOpen);
        bob.getAttendedTournaments().add(playersChampionship);
        session.persist((Object)bob);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Director loadedParticipant = (Director)session.get(Director.class, (Serializable)((Object)"bob"));
        Assertions.assertThat(bob.getAttendedTournaments()).onProperty("name").contains(new Object[]{"British Open", "Player's Championship"});
        loadedParticipant.getAttendedTournaments().remove(session.get(Tournament.class, (Serializable)britishOpen.getId()));
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedParticipant = (Director)session.get(Director.class, (Serializable)((Object)"bob"));
        Assertions.assertThat(bob.getAttendedTournaments()).onProperty("name").contains(new Object[]{"Player's Championship"});
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedParticipant = (Director)session.get(Director.class, (Serializable)((Object)"bob"));
        session.delete((Object)loadedParticipant);
        session.delete(session.get(Tournament.class, (Serializable)britishOpen.getId()));
        session.delete(session.get(Tournament.class, (Serializable)playersChampionship.getId()));
        transaction.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Director.class, Tournament.class, TournamentId.class};
    }
}

