/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.manytoone;

import java.io.Serializable;
import java.util.Arrays;
import org.fest.assertions.Assertions;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.manytoone.Basket;
import org.hibernate.ogm.backendtck.associations.manytoone.Product;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="Basket.products list - bag semantics unsupported (no primary key)")
public class ManyToOneExtraTest
extends OgmTestCase {
    @Test
    public void testUnidirectionalOneToMany() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Product beer = new Product("Beer", "Tactical nuclear penguin");
        session.persist((Object)beer);
        Product pretzel = new Product("Pretzel", "Glutino Pretzel Sticks");
        session.persist((Object)pretzel);
        Basket basket = new Basket();
        basket.setId("davide_basket");
        basket.setOwner("Davide");
        basket.setProducts(Arrays.asList(beer, pretzel));
        session.persist((Object)basket);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        basket = (Basket)session.get(Basket.class, (Serializable)((Object)basket.getId()));
        Assertions.assertThat((Object)basket).isNotNull();
        Assertions.assertThat((String)basket.getId()).isEqualTo((Object)basket.getId());
        Assertions.assertThat(basket.getProducts()).onProperty("name").containsOnly(new Object[]{beer.getName(), pretzel.getName()});
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        session.delete((Object)basket);
        session.delete((Object)pretzel);
        session.delete((Object)beer);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Basket.class, Product.class};
    }
}

