/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.manytoone;

import java.io.Serializable;
import java.util.EnumSet;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.manytoone.Beer;
import org.hibernate.ogm.backendtck.associations.manytoone.Brewery;
import org.hibernate.ogm.backendtck.associations.manytoone.Court;
import org.hibernate.ogm.backendtck.associations.manytoone.Employee;
import org.hibernate.ogm.backendtck.associations.manytoone.Employer;
import org.hibernate.ogm.backendtck.associations.manytoone.Game;
import org.hibernate.ogm.backendtck.associations.manytoone.JUG;
import org.hibernate.ogm.backendtck.associations.manytoone.Member;
import org.hibernate.ogm.backendtck.associations.manytoone.SalesForce;
import org.hibernate.ogm.backendtck.associations.manytoone.SalesGuy;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class ManyToOneTest
extends OgmTestCase {
    @Test
    public void testUnidirectionalManyToOne() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        JUG jug = new JUG("summer_camp");
        jug.setName("JUG Summer Camp");
        session.persist((Object)jug);
        Member emmanuel = new Member("emmanuel");
        emmanuel.setName("Emmanuel Bernard");
        emmanuel.setMemberOf(jug);
        Member jerome = new Member("jerome");
        jerome.setName("Jerome");
        jerome.setMemberOf(jug);
        session.persist((Object)emmanuel);
        session.persist((Object)jerome);
        session.flush();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((Session)session)).isEqualTo(3L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((Session)session)).isEqualTo((Object)this.expectedAssociations());
        transaction.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(3L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo((Object)this.expectedAssociations());
        session.clear();
        transaction = session.beginTransaction();
        emmanuel = (Member)session.get(Member.class, (Serializable)((Object)emmanuel.getId()));
        jug = emmanuel.getMemberOf();
        session.delete((Object)emmanuel);
        jerome = (Member)session.get(Member.class, (Serializable)((Object)jerome.getId()));
        session.delete((Object)jerome);
        session.delete((Object)jug);
        transaction.commit();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessionFactory)).isEqualTo(0L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessionFactory)).isEqualTo(0L);
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void canPersistAssociationToDetachedEntity() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Employer employer = new Employer();
        employer.setId("employer-1");
        employer.setName("Hibernate");
        session.save((Object)employer);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Employee employee = new Employee();
        employee.setId("employee-1");
        employee.setName("DNadar");
        employee.setEmployer(employer);
        session.save((Object)employee);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Employee loadedEmployee = (Employee)session.get(Employee.class, (Serializable)((Object)"employee-1"));
        Assertions.assertThat((String)loadedEmployee.getEmployer().getName()).isEqualTo((Object)"Hibernate");
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Employer loadedEmployer = (Employer)session.get(Employer.class, (Serializable)((Object)"employer-1"));
        Assertions.assertThat(loadedEmployer.getEmployees()).onProperty("name").containsOnly(new Object[]{"DNadar"});
        session.delete((Object)loadedEmployer.getEmployees().iterator().next());
        session.delete((Object)loadedEmployer);
        transaction.commit();
        session.close();
    }

    private Long expectedAssociations() {
        if (EnumSet.of(GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE).contains((Object)TestHelper.getCurrentDialectType())) {
            return 2L;
        }
        return 0L;
    }

    @Test
    public void testBidirectionalManyToOneRegular() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        SalesForce force = new SalesForce("sales_force");
        force.setCorporation("Red Hat");
        session.save((Object)force);
        SalesGuy eric = new SalesGuy("eric");
        eric.setName("Eric");
        eric.setSalesForce(force);
        force.getSalesGuys().add(eric);
        session.save((Object)eric);
        SalesGuy simon = new SalesGuy("simon");
        simon.setName("Simon");
        simon.setSalesForce(force);
        force.getSalesGuys().add(simon);
        session.save((Object)simon);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        force = (SalesForce)session.get(SalesForce.class, (Serializable)((Object)force.getId()));
        Assert.assertNotNull(force.getSalesGuys());
        Assert.assertEquals((long)2L, (long)force.getSalesGuys().size());
        simon = (SalesGuy)session.get(SalesGuy.class, (Serializable)((Object)simon.getId()));
        session.delete((Object)simon);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        force = (SalesForce)session.get(SalesForce.class, (Serializable)((Object)force.getId()));
        Assert.assertNotNull(force.getSalesGuys());
        Assert.assertEquals((long)1L, (long)force.getSalesGuys().size());
        session.delete((Object)force.getSalesGuys().iterator().next());
        session.delete((Object)force);
        transaction.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testBidirectionalManyToOneRemoval() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        SalesForce force = new SalesForce("red_hat");
        force.setCorporation("Red Hat");
        session.save((Object)force);
        SalesGuy eric = new SalesGuy("eric");
        eric.setName("Eric");
        eric.setSalesForce(force);
        force.getSalesGuys().add(eric);
        session.save((Object)eric);
        SalesGuy simon = new SalesGuy("simon");
        simon.setName("Simon");
        simon.setSalesForce(force);
        force.getSalesGuys().add(simon);
        session.save((Object)simon);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        force = (SalesForce)session.get(SalesForce.class, (Serializable)((Object)force.getId()));
        Assert.assertEquals((long)2L, (long)force.getSalesGuys().size());
        SalesGuy salesGuy = (SalesGuy)session.get(SalesGuy.class, (Serializable)((Object)eric.getId()));
        salesGuy.setSalesForce(null);
        force.getSalesGuys().remove(salesGuy);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        force = (SalesForce)session.get(SalesForce.class, (Serializable)((Object)force.getId()));
        Assert.assertEquals((long)1L, (long)force.getSalesGuys().size());
        salesGuy = force.getSalesGuys().iterator().next();
        Assertions.assertThat((String)salesGuy.getName()).isEqualTo((Object)"Simon");
        session.delete(session.get(SalesGuy.class, (Serializable)((Object)eric.getId())));
        session.delete(session.get(SalesGuy.class, (Serializable)((Object)simon.getId())));
        session.delete((Object)force);
        transaction.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testBiDirManyToOneInsertUpdateFalse() throws Exception {
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        Beer hoegaarden = new Beer();
        Brewery hoeBrewery = new Brewery();
        hoeBrewery.getBeers().add(hoegaarden);
        hoegaarden.setBrewery(hoeBrewery);
        session.persist((Object)hoeBrewery);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        hoegaarden = TestHelper.get((Session)session, Beer.class, (Serializable)((Object)hoegaarden.getId()));
        Assertions.assertThat((Object)hoegaarden).isNotNull();
        Assertions.assertThat((Object)hoegaarden.getBrewery()).isNotNull();
        ((CollectionAssert)Assertions.assertThat(hoegaarden.getBrewery().getBeers()).hasSize(1)).containsOnly(new Object[]{hoegaarden});
        Beer citron = new Beer();
        hoeBrewery = hoegaarden.getBrewery();
        hoeBrewery.getBeers().remove(hoegaarden);
        hoeBrewery.getBeers().add(citron);
        citron.setBrewery(hoeBrewery);
        session.delete((Object)hoegaarden);
        tx.commit();
        session.clear();
        tx = session.beginTransaction();
        citron = TestHelper.get((Session)session, Beer.class, (Serializable)((Object)citron.getId()));
        ((CollectionAssert)Assertions.assertThat(citron.getBrewery().getBeers()).hasSize(1)).containsOnly(new Object[]{citron});
        hoeBrewery = citron.getBrewery();
        citron.setBrewery(null);
        hoeBrewery.getBeers().clear();
        session.delete((Object)citron);
        session.delete((Object)hoeBrewery);
        tx.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testRemovalOfTransientEntityWithAssociation() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        SalesForce force = new SalesForce("red_hat");
        force.setCorporation("Red Hat");
        session.save((Object)force);
        SalesGuy eric = new SalesGuy("eric");
        eric.setName("Eric");
        eric.setSalesForce(force);
        force.getSalesGuys().add(eric);
        session.save((Object)eric);
        SalesGuy simon = new SalesGuy("simon");
        simon.setName("Simon");
        simon.setSalesForce(force);
        force.getSalesGuys().add(simon);
        session.save((Object)simon);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        session.delete((Object)force);
        transaction.commit();
        transaction = session.beginTransaction();
        SalesGuy salesGuy = (SalesGuy)session.get(SalesGuy.class, (Serializable)((Object)"eric"));
        ((ObjectAssert)Assertions.assertThat((Object)salesGuy.getSalesForce()).describedAs("Stale association should be exposed as null")).isNull();
        session.delete((Object)salesGuy);
        salesGuy = (SalesGuy)session.get(SalesGuy.class, (Serializable)((Object)"simon"));
        ((ObjectAssert)Assertions.assertThat((Object)salesGuy.getSalesForce()).describedAs("Stale association should be exposed as null")).isNull();
        session.delete((Object)salesGuy);
        transaction.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testDefaultBiDirManyToOneCompositeKeyTest() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Court court = new Court();
        court.setId(new Court.CourtId());
        court.getId().setCountryCode("DE");
        court.getId().setSequenceNo(123);
        court.setName("Hamburg Court");
        session.persist((Object)court);
        Game game1 = new Game();
        game1.setId(new Game.GameId());
        game1.getId().setCategory("primary");
        game1.getId().setSequenceNo(456);
        game1.setName("The game");
        game1.setPlayedOn(court);
        court.getGames().add(game1);
        Game game2 = new Game();
        game2.setId(new Game.GameId());
        game2.getId().setCategory("primary");
        game2.getId().setSequenceNo(457);
        game2.setName("The other game");
        game2.setPlayedOn(court);
        session.persist((Object)game1);
        session.persist((Object)game2);
        session.flush();
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Court localCourt = (Court)session.get(Court.class, (Serializable)new Court.CourtId("DE", 123));
        Assertions.assertThat(localCourt.getGames()).hasSize(2);
        for (Game game : localCourt.getGames()) {
            session.delete((Object)game);
        }
        localCourt.getGames().clear();
        session.delete((Object)localCourt);
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{JUG.class, Member.class, SalesForce.class, SalesGuy.class, Beer.class, Brewery.class, Game.class, Court.class, Employee.class, Employer.class};
    }
}

