/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.onetoone;

import java.io.Serializable;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.onetoone.Cavalier;
import org.hibernate.ogm.backendtck.associations.onetoone.Horse;
import org.hibernate.ogm.backendtck.associations.onetoone.Husband;
import org.hibernate.ogm.backendtck.associations.onetoone.MediaId;
import org.hibernate.ogm.backendtck.associations.onetoone.NetworkSwitch;
import org.hibernate.ogm.backendtck.associations.onetoone.PatchCable;
import org.hibernate.ogm.backendtck.associations.onetoone.Vehicule;
import org.hibernate.ogm.backendtck.associations.onetoone.Wheel;
import org.hibernate.ogm.backendtck.associations.onetoone.Wife;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class OneToOneTest
extends OgmTestCase {
    @Test
    public void testUnidirectionalManyToOne() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Horse horse = new Horse("palefrenier");
        horse.setName("Palefrenier");
        Cavalier cavalier = new Cavalier("caroline");
        cavalier.setName("Caroline");
        cavalier.setHorse(horse);
        session.persist((Object)horse);
        session.persist((Object)cavalier);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        cavalier = (Cavalier)session.get(Cavalier.class, (Serializable)((Object)cavalier.getId()));
        horse = cavalier.getHorse();
        session.delete((Object)cavalier);
        session.delete((Object)horse);
        transaction.commit();
        session.close();
        this.checkCleanCache();
    }

    @Test
    public void testUnidirectionalOneToOne() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Vehicule vehicule = new Vehicule();
        vehicule.setBrand("Mercedes");
        Wheel wheel = new Wheel();
        wheel.setVehicule(vehicule);
        session.persist((Object)vehicule);
        session.persist((Object)wheel);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        wheel = (Wheel)session.get(Wheel.class, (Serializable)((Object)wheel.getId()));
        vehicule = wheel.getVehicule();
        session.delete((Object)wheel);
        session.delete((Object)vehicule);
        transaction.commit();
        session.close();
    }

    @Test
    public void testBidirectionalOneToOne() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Husband husband = new Husband("alex");
        husband.setName("Alex");
        Wife wife = new Wife("bea");
        wife.setName("Bea");
        husband.setWife(wife);
        wife.setHusband(husband);
        session.persist((Object)husband);
        session.persist((Object)wife);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        husband = (Husband)session.get(Husband.class, (Serializable)((Object)husband.getId()));
        Assert.assertNotNull((Object)husband);
        Assert.assertNotNull((Object)husband.getWife());
        session.clear();
        wife = (Wife)session.get(Wife.class, (Serializable)((Object)wife.getId()));
        Assert.assertNotNull((Object)wife);
        husband = wife.getHusband();
        Assert.assertNotNull((Object)husband);
        Wife bea2 = new Wife("still_bea");
        session.persist((Object)bea2);
        bea2.setName("Still Bea");
        husband.setWife(bea2);
        wife.setHusband(null);
        bea2.setHusband(husband);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        husband = (Husband)session.get(Husband.class, (Serializable)((Object)husband.getId()));
        Assert.assertNotNull((Object)husband);
        Assert.assertNotNull((Object)husband.getWife());
        session.clear();
        wife = (Wife)session.get(Wife.class, (Serializable)((Object)wife.getId()));
        Assert.assertNotNull((Object)wife);
        Assert.assertNull((Object)wife.getHusband());
        session.delete((Object)wife);
        bea2 = (Wife)session.get(Wife.class, (Serializable)((Object)bea2.getId()));
        Assert.assertNotNull((Object)bea2);
        husband = bea2.getHusband();
        Assert.assertNotNull((Object)husband);
        bea2.setHusband(null);
        husband.setWife(null);
        session.delete((Object)husband);
        session.delete((Object)wife);
        session.delete((Object)bea2);
        transaction.commit();
        session.close();
    }

    @Test
    public void testBidirectionalOneToOneCompositeId() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        PatchCable patchCable = new PatchCable(new MediaId("Belkin", "cat7"));
        NetworkSwitch networkSwitch = new NetworkSwitch(new MediaId("Frisco", "AS500"));
        patchCable.setNetworkSwitch(networkSwitch);
        networkSwitch.setPatchCable(patchCable);
        session.persist((Object)patchCable);
        session.persist((Object)networkSwitch);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        patchCable = (PatchCable)session.get(PatchCable.class, (Serializable)patchCable.getId());
        Assert.assertNotNull((Object)patchCable);
        Assert.assertNotNull((Object)patchCable.getNetworkSwitch());
        session.clear();
        networkSwitch = (NetworkSwitch)session.get(NetworkSwitch.class, (Serializable)networkSwitch.getId());
        Assert.assertNotNull((Object)networkSwitch);
        patchCable = networkSwitch.getPatchCable();
        Assert.assertNotNull((Object)patchCable);
        Assert.assertNotNull((Object)patchCable.getId());
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        patchCable = (PatchCable)session.get(PatchCable.class, (Serializable)patchCable.getId());
        Assert.assertNotNull((Object)patchCable);
        Assert.assertNotNull((Object)patchCable.getNetworkSwitch());
        session.clear();
        networkSwitch = (NetworkSwitch)session.get(NetworkSwitch.class, (Serializable)networkSwitch.getId());
        Assert.assertNotNull((Object)networkSwitch);
        session.delete((Object)patchCable);
        session.delete((Object)networkSwitch);
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Horse.class, Cavalier.class, Vehicule.class, Wheel.class, Husband.class, Wife.class, NetworkSwitch.class, PatchCable.class};
    }
}

