/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.storageconfiguration;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.Cloud;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.SnowFlake;
import org.hibernate.ogm.backendtck.associations.storageconfiguration.AssociationStorageTestBase;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.navigation.DocumentStoreEntityContext;
import org.hibernate.ogm.datastore.document.options.navigation.DocumentStoreGlobalContext;
import org.hibernate.ogm.datastore.document.options.navigation.DocumentStorePropertyContext;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.After;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE, GridDialectType.CASSANDRA}, comment="Only the document stores CouchDB and MongoDB support the configuration of specific association storage strategies")
public class AssociationStorageConfiguredProgrammaticallyTest
extends AssociationStorageTestBase {
    private Cloud cloud;

    @Test
    public void associationStorageSetToAssociationDocumentOnGlobalLevel() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).associationStorage(AssociationStorageType.ASSOCIATION_DOCUMENT);
        this.setupSessionFactory(settings);
        this.createCloudWithTwoProducedSnowflakes();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(0L);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.REDIS_HASH}, comment="Only Redis JSON supports in-entity association storage")
    public void associationStorageSetToInEntityOnGlobalLevel() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).associationStorage(AssociationStorageType.IN_ENTITY);
        this.setupSessionFactory(settings);
        this.createCloudWithTwoProducedSnowflakes();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    @Test
    public void associationStorageSetToAssociationDocumentOnEntityLevel() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStoreEntityContext)((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).entity(Cloud.class)).associationStorage(AssociationStorageType.ASSOCIATION_DOCUMENT);
        this.setupSessionFactory(settings);
        this.createCloudWithTwoProducedSnowflakes();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(0L);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.REDIS_HASH}, comment="Only Redis JSON supports in-entity association storage")
    public void associationStorageSetToInEntityOnEntityLevel() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStoreEntityContext)((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).entity(Cloud.class)).associationStorage(AssociationStorageType.IN_ENTITY);
        this.setupSessionFactory(settings);
        this.createCloudWithTwoProducedSnowflakes();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.REDIS_HASH}, comment="Only Redis JSON supports in-entity association storage")
    public void associationStorageSetOnPropertyLevel() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStorePropertyContext)((DocumentStorePropertyContext)((DocumentStoreEntityContext)((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).entity(Cloud.class)).property("producedSnowFlakes", ElementType.METHOD)).associationStorage(AssociationStorageType.ASSOCIATION_DOCUMENT).property("backupSnowFlakes", ElementType.METHOD)).associationStorage(AssociationStorageType.IN_ENTITY);
        this.setupSessionFactory(settings);
        this.createCloudWithTwoProducedAndOneBackupSnowflake();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.REDIS_HASH}, comment="Only Redis JSON supports in-entity association storage")
    public void associationStorageSetOnPropertyLevelTakesPrecedenceOverEntityLevel() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStorePropertyContext)((DocumentStoreEntityContext)((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).entity(Cloud.class)).associationStorage(AssociationStorageType.IN_ENTITY).property("backupSnowFlakes", ElementType.METHOD)).associationStorage(AssociationStorageType.ASSOCIATION_DOCUMENT);
        this.setupSessionFactory(settings);
        this.createCloudWithTwoProducedAndOneBackupSnowflake();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    private void createCloudWithTwoProducedSnowflakes() {
        this.cloud = this.newCloud().withLength(23).withProducedSnowflakes("Snowflake1", "Snowflake2").createAndSave();
    }

    private void createCloudWithTwoProducedAndOneBackupSnowflake() {
        this.cloud = this.newCloud().withLength(23).withProducedSnowflakes("Snowflake1", "Snowflake2").withBackupSnowflakes("Snowflake3").createAndSave();
    }

    private CloudBuilder newCloud() {
        return new CloudBuilder();
    }

    @After
    public void removeCloudAndSnowflakes() {
        if (this.sessions != null) {
            try (OgmSession session = this.sessions.openSession();){
                Transaction transaction = session.beginTransaction();
                if (this.cloud != null) {
                    Cloud cloudToDelete = (Cloud)session.get(Cloud.class, (Serializable)((Object)this.cloud.getId()));
                    for (SnowFlake current : cloudToDelete.getProducedSnowFlakes()) {
                        session.delete((Object)current);
                    }
                    for (SnowFlake current : cloudToDelete.getBackupSnowFlakes()) {
                        session.delete((Object)current);
                    }
                    session.delete((Object)cloudToDelete);
                }
                transaction.commit();
            }
            Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessions)).isEqualTo(0L);
            Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessions)).isEqualTo(0L);
        }
    }

    private void setupSessionFactory(Map<String, Object> settings) {
        this.sessions = TestHelper.getDefaultTestSessionFactory(settings, Cloud.class, SnowFlake.class);
    }

    private class CloudBuilder {
        private int length;
        private final List<String> producedSnowflakes = new ArrayList<String>();
        private final List<String> backupSnowflakes = new ArrayList<String>();

        private CloudBuilder() {
        }

        public CloudBuilder withLength(int length) {
            this.length = length;
            return this;
        }

        public CloudBuilder withProducedSnowflakes(String ... descriptions) {
            this.producedSnowflakes.addAll(Arrays.asList(descriptions));
            return this;
        }

        public CloudBuilder withBackupSnowflakes(String ... descriptions) {
            this.backupSnowflakes.addAll(Arrays.asList(descriptions));
            return this;
        }

        public Cloud createAndSave() {
            SnowFlake sf;
            OgmSession session = AssociationStorageConfiguredProgrammaticallyTest.this.sessions.openSession();
            Transaction transaction = session.beginTransaction();
            Cloud cloud = new Cloud();
            cloud.setLength(this.length);
            for (String description : this.producedSnowflakes) {
                sf = new SnowFlake();
                sf.setDescription(description);
                session.save((Object)sf);
                cloud.getProducedSnowFlakes().add(sf);
            }
            for (String description : this.backupSnowflakes) {
                sf = new SnowFlake();
                sf.setDescription(description);
                session.save((Object)sf);
                cloud.getBackupSnowFlakes().add(sf);
            }
            session.persist((Object)cloud);
            transaction.commit();
            session.close();
            return cloud;
        }
    }
}

