/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.storageconfiguration;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.fest.assertions.Assertions;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.Cloud;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.SnowFlake;
import org.hibernate.ogm.backendtck.associations.storageconfiguration.AnnotatedCloud;
import org.hibernate.ogm.backendtck.associations.storageconfiguration.AssociationStorageTestBase;
import org.hibernate.ogm.backendtck.associations.storageconfiguration.PolarCloud;
import org.hibernate.ogm.backendtck.associations.storageconfiguration.SnowFlakeProducer;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.navigation.DocumentStoreEntityContext;
import org.hibernate.ogm.datastore.document.options.navigation.DocumentStoreGlobalContext;
import org.hibernate.ogm.datastore.document.options.navigation.DocumentStorePropertyContext;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.After;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE, GridDialectType.CASSANDRA, GridDialectType.REDIS_HASH}, comment="Only the document stores CouchDB and MongoDB support the configuration of specific association storage strategies")
public class AssociationStorageConfiguredViaAnnotationsTest
extends AssociationStorageTestBase {
    private AnnotatedCloud cloud;
    private PolarCloud polarCloud;

    @Test
    public void associationStorageSetToCollectionOnEntityLevel() throws Exception {
        this.setupSessionFactory();
        this.createCloudWithTwoProducedSnowflakes();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    @Test
    public void associationStorageSetOnPropertyLevelTakesPrecedenceOverEntityLevel() throws Exception {
        this.setupSessionFactory();
        this.createCloudWithTwoProducedAndOneBackupSnowflake();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    @Test
    public void associationStorageSetOnPropertyLevelViaApiTakesPrecedenceOverAnnotation() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStorePropertyContext)((DocumentStoreEntityContext)((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).entity(AnnotatedCloud.class)).property("backupSnowFlakes", ElementType.METHOD)).associationStorage(AssociationStorageType.IN_ENTITY);
        this.sessions = TestHelper.getDefaultTestSessionFactory(settings, AnnotatedCloud.class, Cloud.class, SnowFlake.class);
        this.createCloudWithTwoProducedAndOneBackupSnowflake();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(2L);
    }

    @Test
    public void associationStorageSetOnSubClass() throws Exception {
        this.setupSessionFactory();
        this.createPolarCloudWithTwoProducedAndOneBackupSnowflake();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    private void createCloudWithTwoProducedSnowflakes() {
        this.cloud = this.newCloud().withLength(23).withProducedSnowflakes("Snowflake1", "Snowflake2").createAndSave();
    }

    private void createCloudWithTwoProducedAndOneBackupSnowflake() {
        this.cloud = this.newCloud().withLength(23).withProducedSnowflakes("Snowflake1", "Snowflake2").withBackupSnowflakes("Snowflake3").createAndSave();
    }

    private void createPolarCloudWithTwoProducedAndOneBackupSnowflake() {
        this.polarCloud = this.newPolarCloud().withLength(23).withProducedSnowflakes("Snowflake1", "Snowflake2").withBackupSnowflakes("Snowflake3").createAndSave();
    }

    private CloudBuilder<AnnotatedCloud> newCloud() {
        return new CloudBuilder<AnnotatedCloud>(false);
    }

    private CloudBuilder<PolarCloud> newPolarCloud() {
        return new CloudBuilder<PolarCloud>(true);
    }

    @After
    public void removeCloudAndSnowflakes() {
        Object cloudToDelete;
        OgmSession session = this.sessions.openSession();
        Transaction transaction = session.beginTransaction();
        if (this.cloud != null) {
            cloudToDelete = (AnnotatedCloud)session.get(AnnotatedCloud.class, (Serializable)((Object)this.cloud.getId()));
            for (SnowFlake current : ((AnnotatedCloud)cloudToDelete).getProducedSnowFlakes()) {
                session.delete((Object)current);
            }
            for (SnowFlake current : ((AnnotatedCloud)cloudToDelete).getBackupSnowFlakes()) {
                session.delete((Object)current);
            }
            session.delete(cloudToDelete);
        }
        if (this.polarCloud != null) {
            cloudToDelete = (PolarCloud)session.get(PolarCloud.class, (Serializable)((Object)this.polarCloud.getId()));
            for (SnowFlake current : ((SnowFlakeProducer)cloudToDelete).getProducedSnowFlakes()) {
                session.delete((Object)current);
            }
            for (SnowFlake current : ((SnowFlakeProducer)cloudToDelete).getBackupSnowFlakes()) {
                session.delete((Object)current);
            }
            session.delete(cloudToDelete);
        }
        transaction.commit();
        session.close();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessions)).isEqualTo(0L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessions)).isEqualTo(0L);
        this.sessions.close();
    }

    private void setupSessionFactory() {
        this.sessions = TestHelper.getDefaultTestSessionFactory(AnnotatedCloud.class, PolarCloud.class, SnowFlake.class);
    }

    private class CloudBuilder<T> {
        private final boolean polar;
        private int length;
        private final List<String> producedSnowflakes = new ArrayList<String>();
        private final List<String> backupSnowflakes = new ArrayList<String>();

        private CloudBuilder(boolean polar) {
            this.polar = polar;
        }

        public CloudBuilder<T> withLength(int length) {
            this.length = length;
            return this;
        }

        public CloudBuilder<T> withProducedSnowflakes(String ... descriptions) {
            this.producedSnowflakes.addAll(Arrays.asList(descriptions));
            return this;
        }

        public CloudBuilder<T> withBackupSnowflakes(String ... descriptions) {
            this.backupSnowflakes.addAll(Arrays.asList(descriptions));
            return this;
        }

        public T createAndSave() {
            OgmSession session = AssociationStorageConfiguredViaAnnotationsTest.this.sessions.openSession();
            Transaction transaction = session.beginTransaction();
            Object cloud = null;
            if (this.polar) {
                SnowFlake sf;
                PolarCloud polarCloud = new PolarCloud();
                polarCloud.setLength(this.length);
                for (String description : this.producedSnowflakes) {
                    sf = new SnowFlake();
                    sf.setDescription(description);
                    session.save((Object)sf);
                    polarCloud.getProducedSnowFlakes().add(sf);
                }
                for (String description : this.backupSnowflakes) {
                    sf = new SnowFlake();
                    sf.setDescription(description);
                    session.save((Object)sf);
                    polarCloud.getBackupSnowFlakes().add(sf);
                }
                cloud = polarCloud;
            } else {
                SnowFlake sf;
                AnnotatedCloud annotatedCloud = new AnnotatedCloud();
                annotatedCloud.setLength(this.length);
                for (String description : this.producedSnowflakes) {
                    sf = new SnowFlake();
                    sf.setDescription(description);
                    session.save((Object)sf);
                    annotatedCloud.getProducedSnowFlakes().add(sf);
                }
                for (String description : this.backupSnowflakes) {
                    sf = new SnowFlake();
                    sf.setDescription(description);
                    session.save((Object)sf);
                    annotatedCloud.getBackupSnowFlakes().add(sf);
                }
                cloud = annotatedCloud;
            }
            session.persist(cloud);
            transaction.commit();
            session.close();
            Object result = cloud;
            return (T)result;
        }
    }
}

