/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.associations.storageconfiguration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.fest.assertions.Assertions;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.Cloud;
import org.hibernate.ogm.backendtck.associations.collection.unidirectional.SnowFlake;
import org.hibernate.ogm.backendtck.associations.storageconfiguration.AssociationStorageTestBase;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.navigation.DocumentStoreGlobalContext;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.After;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.EHCACHE, GridDialectType.HASHMAP, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE, GridDialectType.CASSANDRA}, comment="Only the document stores CouchDB and MongoDB support the configuration of specific association storage strategies")
public class AssociationStorageConfiguredViaPropertyTest
extends AssociationStorageTestBase {
    private Cloud cloud;

    @Test
    public void associationStorageSetToAssociationDocumentViaProperty() throws Exception {
        this.setupSessionFactory();
        this.createCloudWithTwoProducedSnowflakes();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(1L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(0L);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.REDIS_HASH}, comment="Only Redis JSON supports in-entity association storage")
    public void associationStorageSetViaApiTakesPrecedenceOverProperty() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        ((DocumentStoreGlobalContext)TestHelper.configureOptionsFor(settings, this.getDocumentDatastoreConfiguration())).associationStorage(AssociationStorageType.IN_ENTITY);
        this.sessions = TestHelper.getDefaultTestSessionFactory(settings, Cloud.class, SnowFlake.class);
        this.createCloudWithTwoProducedSnowflakes();
        Assertions.assertThat((long)this.associationDocumentCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.inEntityAssociationCount()).isEqualTo(1L);
    }

    private void createCloudWithTwoProducedSnowflakes() {
        this.cloud = this.newCloud().withLength(23).withProducedSnowflakes("Snowflake1", "Snowflake2").createAndSave();
    }

    private CloudBuilder newCloud() {
        return new CloudBuilder();
    }

    @After
    public void removeCloudAndSnowflakes() {
        OgmSession session = this.sessions.openSession();
        Transaction transaction = session.beginTransaction();
        if (this.cloud != null) {
            Cloud cloudToDelete = (Cloud)session.get(Cloud.class, (Serializable)((Object)this.cloud.getId()));
            for (SnowFlake current : cloudToDelete.getProducedSnowFlakes()) {
                session.delete((Object)current);
            }
            for (SnowFlake current : cloudToDelete.getBackupSnowFlakes()) {
                session.delete((Object)current);
            }
            session.delete((Object)cloudToDelete);
        }
        transaction.commit();
        session.close();
        Assertions.assertThat((long)TestHelper.getNumberOfEntities((SessionFactory)this.sessions)).isEqualTo(0L);
        Assertions.assertThat((long)TestHelper.getNumberOfAssociations((SessionFactory)this.sessions)).isEqualTo(0L);
    }

    private void setupSessionFactory() {
        this.sessions = TestHelper.getDefaultTestSessionFactory(Collections.singletonMap("hibernate.ogm.datastore.document.association_storage", AssociationStorageType.ASSOCIATION_DOCUMENT), Cloud.class, SnowFlake.class);
    }

    private class CloudBuilder {
        private int length;
        private final List<String> producedSnowflakes = new ArrayList<String>();

        private CloudBuilder() {
        }

        public CloudBuilder withLength(int length) {
            this.length = length;
            return this;
        }

        public CloudBuilder withProducedSnowflakes(String ... descriptions) {
            this.producedSnowflakes.addAll(Arrays.asList(descriptions));
            return this;
        }

        public Cloud createAndSave() {
            OgmSession session = AssociationStorageConfiguredViaPropertyTest.this.sessions.openSession();
            Transaction transaction = session.beginTransaction();
            Cloud cloud = new Cloud();
            cloud.setLength(this.length);
            for (String description : this.producedSnowflakes) {
                SnowFlake sf = new SnowFlake();
                sf.setDescription(description);
                session.save((Object)sf);
                cloud.getProducedSnowFlakes().add(sf);
            }
            session.persist((Object)cloud);
            transaction.commit();
            session.close();
            return cloud;
        }
    }
}

