/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.batchfetching;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.batchfetching.Condominium;
import org.hibernate.ogm.backendtck.batchfetching.CondominiumBuilding;
import org.hibernate.ogm.backendtck.batchfetching.Floor;
import org.hibernate.ogm.backendtck.batchfetching.Tower;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.utils.InvokedOperationsLoggingDialect;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.stat.Statistics;
import org.junit.Assert;
import org.junit.Test;

public class BatchFetchingTest
extends OgmTestCase {
    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Tower.class, Floor.class, CondominiumBuilding.class, Condominium.class};
    }

    @Test
    public void testLoadSeveralFloorsByBatch() throws Exception {
        OgmSession session = this.openSession();
        Tower tower = this.prepareTower((Session)session);
        session.clear();
        session.beginTransaction();
        for (Floor floor : tower.getFloors()) {
            Assert.assertFalse((boolean)Hibernate.isInitialized((Object)session.load(Floor.class, (Serializable)floor.getId())));
        }
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.setStatisticsEnabled(true);
        statistics.clear();
        Assert.assertEquals((long)0L, (long)statistics.getEntityStatistics(Floor.class.getName()).getFetchCount());
        this.getOperationsLogger().reset();
        for (Floor currentFloor : tower.getFloors()) {
            Object entity = session.load(Floor.class, (Serializable)currentFloor.getId());
            Hibernate.initialize((Object)entity);
            Assert.assertTrue((boolean)Hibernate.isInitialized((Object)entity));
        }
        int n = this.isMultigetDialect() ? 1 : 2;
        Assert.assertEquals((long)n, (long)statistics.getEntityStatistics(Floor.class.getName()).getFetchCount());
        if (this.isMultigetDialect()) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuples"});
        } else {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getTuple"});
        }
        session.getTransaction().commit();
        this.cleanTower((Session)session, tower);
        session.close();
    }

    @Test
    public void testLoadSeveralFloorsFromTower() throws Exception {
        OgmSession session = this.openSession();
        Tower tower = this.prepareTower((Session)session);
        session.clear();
        session.beginTransaction();
        tower = (Tower)session.get(Tower.class, (Serializable)tower.getId());
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.setStatisticsEnabled(true);
        statistics.clear();
        Assert.assertEquals((long)0L, (long)statistics.getEntityStatistics(Floor.class.getName()).getFetchCount());
        this.getOperationsLogger().reset();
        Assertions.assertThat(tower.getFloors()).hasSize(2);
        int fetchSize = this.isMultigetDialect() ? 1 : 2;
        Assert.assertEquals((long)fetchSize, (long)statistics.getEntityStatistics(Floor.class.getName()).getFetchCount());
        session.getTransaction().commit();
        if (this.isMultigetDialect()) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getAssociation", "getTuples"});
        } else {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getAssociation", "getTuple", "getTuple"});
        }
        this.cleanTower((Session)session, tower);
        session.close();
    }

    @Test
    public void testMultigetIsAppliedWithoutExplicitBatchSizeGiven() throws Exception {
        OgmSession session = this.openSession();
        this.prepareCondoBuilding((Session)session);
        session.clear();
        session.beginTransaction();
        CondominiumBuilding condoBuilding = (CondominiumBuilding)session.get(CondominiumBuilding.class, (Serializable)((Object)"cb-1"));
        Statistics statistics = session.getSessionFactory().getStatistics();
        statistics.setStatisticsEnabled(true);
        statistics.clear();
        Assert.assertEquals((long)0L, (long)statistics.getEntityStatistics(Condominium.class.getName()).getFetchCount());
        this.getOperationsLogger().reset();
        Assertions.assertThat(condoBuilding.getCondominiums()).hasSize(3);
        int fetchSize = this.isMultigetDialect() ? 1 : 3;
        Assert.assertEquals((long)fetchSize, (long)statistics.getEntityStatistics(Condominium.class.getName()).getFetchCount());
        session.getTransaction().commit();
        if (this.isMultigetDialect()) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getAssociation", "getTuples"});
        } else {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getAssociation", "getTuple", "getTuple", "getTuple"});
        }
        this.cleanCondoBuilding((Session)session);
        session.close();
    }

    private void cleanTower(Session session, Tower tower) {
        session.beginTransaction();
        session.delete(session.get(Tower.class, (Serializable)tower.getId()));
        for (Floor currentFloor : tower.getFloors()) {
            session.delete(session.get(Floor.class, (Serializable)currentFloor.getId()));
        }
        session.delete((Object)new CondominiumBuilding("cb-1"));
        session.getTransaction().commit();
    }

    private Tower prepareTower(Session session) {
        session.beginTransaction();
        Tower tower = new Tower();
        tower.setName("Pise");
        Floor floor = new Floor();
        floor.setLevel(0);
        tower.getFloors().add(floor);
        floor = new Floor();
        floor.setLevel(1);
        tower.getFloors().add(floor);
        session.persist((Object)tower);
        session.getTransaction().commit();
        return tower;
    }

    private void cleanCondoBuilding(Session session) {
        session.beginTransaction();
        session.delete(session.get(CondominiumBuilding.class, (Serializable)((Object)"cb-1")));
        session.getTransaction().commit();
    }

    private CondominiumBuilding prepareCondoBuilding(Session session) {
        session.beginTransaction();
        CondominiumBuilding condoBuilding = new CondominiumBuilding();
        condoBuilding.setId("cb-1");
        condoBuilding.getCondominiums().add(new Condominium("condo-1", 110));
        condoBuilding.getCondominiums().add(new Condominium("condo-2", 90));
        condoBuilding.getCondominiums().add(new Condominium("condo-3", 135));
        session.persist((Object)condoBuilding);
        session.getTransaction().commit();
        return condoBuilding;
    }

    private boolean isMultigetDialect() {
        GridDialect gridDialect = (GridDialect)this.getSessionFactory().getServiceRegistry().getService(GridDialect.class);
        return GridDialects.hasFacet((GridDialect)gridDialect, MultigetGridDialect.class);
    }

    @Override
    protected void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.ogm.datastore.grid_dialect", InvokedOperationsLoggingDialect.class);
    }

    private InvokedOperationsLoggingDialect getOperationsLogger() {
        GridDialect gridDialect = (GridDialect)this.getSessionFactory().getServiceRegistry().getService(GridDialect.class);
        InvokedOperationsLoggingDialect invocationLogger = (InvokedOperationsLoggingDialect)GridDialects.getDelegateOrNull((GridDialect)gridDialect, InvokedOperationsLoggingDialect.class);
        return invocationLogger;
    }

    private List<String> getOperations() {
        return this.getOperationsLogger().getOperations();
    }
}

