/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.batchfetching;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.utils.GridDialectOperationContexts;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.INFINISPAN, GridDialectType.INFINISPAN_REMOTE, GridDialectType.EHCACHE, GridDialectType.REDIS_HASH})
public class MultiGetEmbeddedIdTest
extends OgmTestCase {
    private static final EntityKeyMetadata METADATA = new DefaultEntityKeyMetadata("BoardGame", new String[]{"id.name", "id.publisher"});
    private static final EntityKey NOT_IN_THE_DB = new EntityKey(METADATA, new Object[]{"none", "none"});
    private static final BoardGame DOMINION = new BoardGame("Rio Grande Games", "Dominion");
    private static final BoardGame KING_OF_TOKYO = new BoardGame("Fantasmagoria", "King of Tokyo");
    private static final BoardGame SPLENDOR = new BoardGame("Space Cowboys", "Splendor");

    @Test
    public void testGetTuplesWithoutNulls() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                MultigetGridDialect dialect = this.multiGetGridDialect();
                EntityKey[] keys = new EntityKey[]{this.key(SPLENDOR), this.key(DOMINION), this.key(KING_OF_TOKYO)};
                List tuples = dialect.getTuples(keys, this.tupleContext((Session)session));
                Assertions.assertThat((Object)((Tuple)tuples.get(0)).get("id.publisher")).isEqualTo((Object)SPLENDOR.getId().getPublisher());
                Assertions.assertThat((Object)((Tuple)tuples.get(0)).get("id.name")).isEqualTo((Object)SPLENDOR.getId().getName());
                Assertions.assertThat((Object)((Tuple)tuples.get(1)).get("id.publisher")).isEqualTo((Object)DOMINION.getId().getPublisher());
                Assertions.assertThat((Object)((Tuple)tuples.get(1)).get("id.name")).isEqualTo((Object)DOMINION.getId().getName());
                Assertions.assertThat((Object)((Tuple)tuples.get(2)).get("id.publisher")).isEqualTo((Object)KING_OF_TOKYO.getId().getPublisher());
                Assertions.assertThat((Object)((Tuple)tuples.get(2)).get("id.name")).isEqualTo((Object)KING_OF_TOKYO.getId().getName());
                session.getTransaction().commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    private EntityKey key(BoardGame boardGame) {
        Object[] values = new Object[]{boardGame.getId().getName(), boardGame.getId().getPublisher()};
        return new EntityKey(METADATA, values);
    }

    @Test
    public void testGetTuplesWithNulls() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                MultigetGridDialect dialect = this.multiGetGridDialect();
                EntityKey[] keys = new EntityKey[]{NOT_IN_THE_DB, this.key(KING_OF_TOKYO), NOT_IN_THE_DB, NOT_IN_THE_DB};
                List tuples = dialect.getTuples(keys, this.tupleContext((Session)session));
                Assertions.assertThat(tuples.get(0)).isNull();
                Assertions.assertThat((Object)((Tuple)tuples.get(1)).get("id.publisher")).isEqualTo((Object)KING_OF_TOKYO.getId().getPublisher());
                Assertions.assertThat((Object)((Tuple)tuples.get(1)).get("id.name")).isEqualTo((Object)KING_OF_TOKYO.getId().getName());
                Assertions.assertThat(tuples.get(2)).isNull();
                Assertions.assertThat(tuples.get(3)).isNull();
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    @Test
    public void testGetTuplesWithAllNulls() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                MultigetGridDialect dialect = this.multiGetGridDialect();
                EntityKey[] keys = new EntityKey[]{NOT_IN_THE_DB, NOT_IN_THE_DB, NOT_IN_THE_DB, NOT_IN_THE_DB};
                List tuples = dialect.getTuples(keys, this.tupleContext((Session)session));
                Assertions.assertThat((List)tuples).containsExactly(new Object[]{null, null, null, null});
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    @Before
    public void prepareDataset() {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                session.persist((Object)DOMINION);
                session.persist((Object)KING_OF_TOKYO);
                session.persist((Object)SPLENDOR);
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    @After
    public void deleteDataset() {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                this.delete(session, DOMINION);
                this.delete(session, SPLENDOR);
                this.delete(session, KING_OF_TOKYO);
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    private TupleContext tupleContext(Session session) {
        return new GridDialectOperationContexts.TupleContextBuilder().tupleTypeContext(new GridDialectOperationContexts.TupleTypeContextBuilder().selectableColumns(METADATA.getColumnNames()).buildTupleTypeContext()).transactionContext(session).buildTupleContext();
    }

    private void delete(OgmSession session, BoardGame boardGame) {
        session.delete(session.load(BoardGame.class, (Serializable)boardGame.getId()));
    }

    private MultigetGridDialect multiGetGridDialect() {
        MultigetGridDialect gridDialect = (MultigetGridDialect)this.getSessionFactory().getServiceRegistry().getService(MultigetGridDialect.class);
        return gridDialect;
    }

    private void rollback(Transaction tx) {
        if (tx != null) {
            tx.rollback();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{BoardGame.class};
    }

    @Embeddable
    public static class BoardGamePK
    implements Serializable {
        private String publisher;
        private String name;

        public BoardGamePK() {
        }

        public BoardGamePK(String name, String publisher) {
            this.name = name;
            this.publisher = publisher;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.publisher == null ? 0 : this.publisher.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BoardGamePK other = (BoardGamePK)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.publisher == null ? other.publisher != null : !this.publisher.equals(other.publisher));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BoardGamePK [publisher=");
            builder.append(this.publisher);
            builder.append(", name=");
            builder.append(this.name);
            builder.append("]");
            return builder.toString();
        }
    }

    @Entity
    @Table(name="BoardGame")
    static class BoardGame
    implements Serializable {
        @EmbeddedId
        private BoardGamePK id;

        public BoardGame() {
        }

        public BoardGame(String name, String publisher) {
            this.id = new BoardGamePK(name, publisher);
        }

        public BoardGamePK getId() {
            return this.id;
        }

        public void setId(BoardGamePK id) {
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BoardGame other = (BoardGame)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BoardGame [id=");
            builder.append(this.id);
            builder.append("]");
            return builder.toString();
        }
    }
}

