/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.batchfetching;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.utils.GridDialectOperationContexts;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.COUCHDB, GridDialectType.INFINISPAN, GridDialectType.EHCACHE, GridDialectType.REDIS_HASH})
public class MultiGetSingleColumnIdTest
extends OgmTestCase {
    private static final EntityKeyMetadata METADATA = new DefaultEntityKeyMetadata("BoardGame", new String[]{"id"});
    private static final EntityKey NOT_IN_THE_DB = new EntityKey(METADATA, new Object[]{-666});
    private static final BoardGame DOMINION = new BoardGame(1, "Dominion");
    private static final BoardGame KING_OF_TOKYO = new BoardGame(2, "King of Tokyo");
    private static final BoardGame SPLENDOR = new BoardGame(3, "Splendor");

    @Test
    public void testGetTuplesWithoutNulls() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                MultigetGridDialect dialect = this.multiGetGridDialect();
                EntityKey[] keys = new EntityKey[]{this.key(SPLENDOR), this.key(DOMINION), this.key(KING_OF_TOKYO)};
                List tuples = dialect.getTuples(keys, this.tupleContext((Session)session));
                Assertions.assertThat((Integer)this.id((Tuple)tuples.get(0))).isEqualTo((Object)SPLENDOR.getId());
                Assertions.assertThat((String)this.name((Tuple)tuples.get(0))).isEqualTo((Object)SPLENDOR.getName());
                Assertions.assertThat((Integer)this.id((Tuple)tuples.get(1))).isEqualTo((Object)DOMINION.getId());
                Assertions.assertThat((String)this.name((Tuple)tuples.get(1))).isEqualTo((Object)DOMINION.getName());
                Assertions.assertThat((Integer)this.id((Tuple)tuples.get(2))).isEqualTo((Object)KING_OF_TOKYO.getId());
                Assertions.assertThat((String)this.name((Tuple)tuples.get(2))).isEqualTo((Object)KING_OF_TOKYO.getName());
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    @Test
    public void testGetTuplesWithNulls() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                MultigetGridDialect dialect = this.multiGetGridDialect();
                EntityKey[] keys = new EntityKey[]{NOT_IN_THE_DB, this.key(KING_OF_TOKYO), NOT_IN_THE_DB, NOT_IN_THE_DB};
                List tuples = dialect.getTuples(keys, this.tupleContext((Session)session));
                Assertions.assertThat(tuples.get(0)).isNull();
                Assertions.assertThat((Integer)this.id((Tuple)tuples.get(1))).isEqualTo((Object)KING_OF_TOKYO.getId());
                Assertions.assertThat((String)this.name((Tuple)tuples.get(1))).isEqualTo((Object)KING_OF_TOKYO.getName());
                Assertions.assertThat(tuples.get(2)).isNull();
                Assertions.assertThat(tuples.get(3)).isNull();
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    @Test
    public void testGetTuplesWithAllNulls() throws Exception {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                MultigetGridDialect dialect = this.multiGetGridDialect();
                EntityKey[] keys = new EntityKey[]{NOT_IN_THE_DB, NOT_IN_THE_DB, NOT_IN_THE_DB, NOT_IN_THE_DB};
                List tuples = dialect.getTuples(keys, this.tupleContext((Session)session));
                Assertions.assertThat((List)tuples).containsExactly(new Object[]{null, null, null, null});
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    private TupleContext tupleContext(Session session) {
        return new GridDialectOperationContexts.TupleContextBuilder().tupleTypeContext(new GridDialectOperationContexts.TupleTypeContextBuilder().selectableColumns("name", "publisher").buildTupleTypeContext()).transactionContext(session).buildTupleContext();
    }

    private EntityKey key(BoardGame boardGame) {
        Object[] values = new Object[]{boardGame.getId()};
        return new EntityKey(METADATA, values);
    }

    @Before
    public void prepareDataset() {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            try {
                session.persist((Object)DOMINION);
                session.persist((Object)KING_OF_TOKYO);
                session.persist((Object)SPLENDOR);
                tx.commit();
            }
            catch (Exception e) {
                this.rollback(tx);
                throw e;
            }
        }
    }

    @After
    public void deleteDataset() {
        try (OgmSession session = this.openSession();){
            Transaction tx = session.beginTransaction();
            this.delete(session, DOMINION);
            this.delete(session, SPLENDOR);
            this.delete(session, KING_OF_TOKYO);
            tx.commit();
        }
    }

    private void delete(OgmSession session, BoardGame boardGame) {
        session.delete(session.load(BoardGame.class, (Serializable)boardGame.getId()));
    }

    private MultigetGridDialect multiGetGridDialect() {
        MultigetGridDialect gridDialect = (MultigetGridDialect)this.getSessionFactory().getServiceRegistry().getService(MultigetGridDialect.class);
        return gridDialect;
    }

    private void rollback(Transaction tx) {
        if (tx != null) {
            tx.rollback();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{BoardGame.class};
    }

    private Integer id(Tuple tuple) {
        Object object = tuple.get("id");
        Integer integer = Integer.valueOf(String.valueOf(object));
        return integer;
    }

    private String name(Tuple tuple) {
        Object object = tuple.get("name");
        return String.valueOf(object);
    }

    @Entity
    @Table(name="BoardGame")
    public static class BoardGame
    implements Serializable {
        @Id
        private Integer id;
        private String name;

        public BoardGame() {
        }

        public BoardGame(Integer id, String name) {
            this.id = id;
            this.name = name;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BoardGame other = (BoardGame)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BoardGame [id=");
            builder.append(this.id);
            builder.append(", name=");
            builder.append(this.name);
            builder.append("]");
            return builder.toString();
        }
    }
}

