/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.callbacks;

import java.util.HashSet;
import javax.persistence.EntityManager;
import org.hibernate.ogm.backendtck.callbacks.Animal;
import org.hibernate.ogm.backendtck.callbacks.Zoo;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="Zoo.animals set - bag semantics unsupported (no primary key)")
public class PostLoadTest
extends OgmJpaTestCase {
    @Test
    public void testFieldSetInPostLoad() {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        Zoo zoo = new Zoo();
        zoo.setId(1);
        HashSet<Animal> animals = new HashSet<Animal>();
        animals.add(this.createAnimal("Giraffe"));
        animals.add(this.createAnimal("Elephant"));
        animals.add(this.createAnimal("Panda"));
        zoo.setAnimals(animals);
        em.persist((Object)zoo);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        zoo = (Zoo)em.find(Zoo.class, (Object)zoo.getId());
        Assert.assertNotNull((Object)zoo);
        Assert.assertEquals((long)3L, (long)zoo.getNrOfAnimals());
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void testFieldSetInPostLoadByListener() {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        Zoo zoo = new Zoo();
        zoo.setId(1);
        HashSet<Animal> animals = new HashSet<Animal>();
        animals.add(this.createAnimal("Giraffe"));
        animals.add(this.createAnimal("Elephant"));
        animals.add(this.createAnimal("Panda"));
        zoo.setAnimals(animals);
        em.persist((Object)zoo);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        zoo = (Zoo)em.find(Zoo.class, (Object)zoo.getId());
        Assert.assertNotNull((Object)zoo);
        Assert.assertEquals((long)3L, (long)zoo.getNrOfAnimalsByListener());
        em.getTransaction().commit();
        em.close();
    }

    private Animal createAnimal(String name) {
        Animal animal = new Animal();
        animal.setName(name);
        return animal;
    }

    @Override
    @After
    public void removeEntities() throws Exception {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        em.remove(em.find(Zoo.class, (Object)1));
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Zoo.class};
    }
}

