/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.callbacks;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import org.hibernate.ogm.backendtck.callbacks.Animal;

@Entity
@EntityListeners(value={ZooEventListener.class})
public class Zoo {
    @Id
    private Integer id;
    @ElementCollection
    private Set<Animal> animals = new HashSet<Animal>();
    private int nrOfAnimals;
    private int nrOfAnimalsByListener;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Set<Animal> getAnimals() {
        return this.animals;
    }

    public void setAnimals(Set<Animal> animals) {
        this.animals = animals;
    }

    @Transient
    public int getNrOfAnimals() {
        return this.nrOfAnimals;
    }

    @Transient
    public int getNrOfAnimalsByListener() {
        return this.nrOfAnimalsByListener;
    }

    @PostLoad
    public void postLoad() {
        this.nrOfAnimals = this.animals.size();
    }

    public static class ZooEventListener {
        @PostLoad
        public void postLoad(Zoo zoo) {
            zoo.nrOfAnimalsByListener = zoo.animals.size();
        }
    }
}

