/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.compensation;

import java.util.HashMap;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.TransactionManager;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.ogm.backendtck.compensation.InvocationTrackingHandler;
import org.hibernate.ogm.backendtck.compensation.Shipment;
import org.hibernate.ogm.compensation.ErrorHandler;
import org.hibernate.ogm.compensation.operation.CreateTupleWithKey;
import org.hibernate.ogm.compensation.operation.ExecuteBatch;
import org.hibernate.ogm.compensation.operation.GridDialectOperation;
import org.hibernate.ogm.compensation.operation.InsertOrUpdateTuple;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.ogm.utils.jpa.GetterPersistenceUnitInfo;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA}, comment="Cassandra always upserts, doesn't read-lock before write, doesn't support unique constraints even on primary key except by explicit/slow CAS use")
public class CompensationSpiJpaTest
extends OgmJpaTestCase {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/transaction-type-jta.xml", Shipment.class);

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB, GridDialectType.INFINISPAN_REMOTE}, comment="MongoDB and Infinispan Remote tests runs w/o transaction manager")
    public void onRollbackTriggeredThroughJtaPresentsAppliedInsertOperations() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.putAll(TestHelper.getDefaultTestSettings());
        settings.put("hibernate.ogm.error_handler", InvocationTrackingHandler.INSTANCE);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"transaction-type-jta", settings);
        TransactionManager transactionManager = this.getTransactionManager(emf);
        transactionManager.begin();
        EntityManager em = emf.createEntityManager();
        em.persist((Object)new Shipment("shipment-1", "INITIAL"));
        em.persist((Object)new Shipment("shipment-2", "INITIAL"));
        em.flush();
        em.clear();
        try {
            em.persist((Object)new Shipment("shipment-1", "INITIAL"));
            transactionManager.commit();
            Fail.fail((String)"Expected exception was not raised");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator<ErrorHandler.RollbackContext> onRollbackInvocations = InvocationTrackingHandler.INSTANCE.getOnRollbackInvocations().iterator();
        Iterator appliedOperations = onRollbackInvocations.next().getAppliedGridDialectOperations().iterator();
        Assertions.assertThat((boolean)onRollbackInvocations.hasNext()).isFalse();
        if (this.currentDialectHasFacet(BatchableGridDialect.class) || this.currentDialectHasFacet(GroupingByEntityDialect.class)) {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            GridDialectOperation operation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)operation).isInstanceOf(ExecuteBatch.class);
            ExecuteBatch batch = (ExecuteBatch)operation.as(ExecuteBatch.class);
            Iterator batchedOperations = batch.getOperations().iterator();
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat((boolean)batchedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
        }
        if (this.currentDialectUsesLookupDuplicatePreventionStrategy()) {
            Assertions.assertThat((boolean)appliedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
        }
        transactionManager.begin();
        em.joinTransaction();
        Shipment shipment = (Shipment)em.find(Shipment.class, (Object)"shipment-1");
        if (shipment != null) {
            em.remove((Object)shipment);
        }
        if ((shipment = (Shipment)em.find(Shipment.class, (Object)"shipment-2")) != null) {
            em.remove((Object)shipment);
        }
        transactionManager.commit();
        em.close();
    }

    @Test
    public void onRollbackTriggeredThroughManualRollbackPresentsAppliedInsertOperations() throws Exception {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new Shipment("shipment-1", "INITIAL"));
        em.persist((Object)new Shipment("shipment-2", "INITIAL"));
        em.flush();
        em.clear();
        try {
            em.persist((Object)new Shipment("shipment-1", "INITIAL"));
            em.getTransaction().commit();
            Fail.fail((String)"Expected exception was not raised");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator<ErrorHandler.RollbackContext> onRollbackInvocations = InvocationTrackingHandler.INSTANCE.getOnRollbackInvocations().iterator();
        Iterator appliedOperations = onRollbackInvocations.next().getAppliedGridDialectOperations().iterator();
        Assertions.assertThat((boolean)onRollbackInvocations.hasNext()).isFalse();
        if (this.currentDialectHasFacet(BatchableGridDialect.class) || this.currentDialectHasFacet(GroupingByEntityDialect.class)) {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            GridDialectOperation operation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)operation).isInstanceOf(ExecuteBatch.class);
            ExecuteBatch batch = (ExecuteBatch)operation.as(ExecuteBatch.class);
            Iterator batchedOperations = batch.getOperations().iterator();
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat((boolean)batchedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
        }
        if (this.currentDialectUsesLookupDuplicatePreventionStrategy()) {
            Assertions.assertThat((boolean)appliedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
        }
        em.clear();
        em.getTransaction().begin();
        Shipment shipment = (Shipment)em.find(Shipment.class, (Object)"shipment-1");
        if (shipment != null) {
            em.remove((Object)shipment);
        }
        if ((shipment = (Shipment)em.find(Shipment.class, (Object)"shipment-2")) != null) {
            em.remove((Object)shipment);
        }
        em.getTransaction().commit();
        em.close();
    }

    @After
    public void resetErrorHandler() throws Exception {
        InvocationTrackingHandler.INSTANCE.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Shipment.class};
    }

    @Override
    protected void configure(GetterPersistenceUnitInfo info) {
        info.getProperties().put("hibernate.ogm.error_handler", InvocationTrackingHandler.INSTANCE);
    }

    private boolean currentDialectHasFacet(Class<? extends GridDialect> facet) {
        SessionFactoryImplementor sfi = ((HibernateEntityManagerFactory)this.getFactory()).getSessionFactory();
        GridDialect gridDialect = (GridDialect)sfi.getServiceRegistry().getService(GridDialect.class);
        return GridDialects.hasFacet((GridDialect)gridDialect, facet);
    }

    private boolean currentDialectUsesLookupDuplicatePreventionStrategy() {
        SessionFactoryImplementor sfi = ((HibernateEntityManagerFactory)this.getFactory()).getSessionFactory();
        GridDialect gridDialect = (GridDialect)sfi.getServiceRegistry().getService(GridDialect.class);
        DefaultEntityKeyMetadata ekm = new DefaultEntityKeyMetadata("Shipment", new String[]{"id"});
        return gridDialect.getDuplicateInsertPreventionStrategy((EntityKeyMetadata)ekm) == DuplicateInsertPreventionStrategy.LOOK_UP;
    }
}

