/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.compensation;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.hibernate.StaleObjectStateException;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.backendtck.compensation.ContinuingErrorHandler;
import org.hibernate.ogm.backendtck.compensation.InvocationTrackingHandler;
import org.hibernate.ogm.backendtck.compensation.Shipment;
import org.hibernate.ogm.compensation.ErrorHandler;
import org.hibernate.ogm.compensation.operation.CreateTupleWithKey;
import org.hibernate.ogm.compensation.operation.ExecuteBatch;
import org.hibernate.ogm.compensation.operation.GridDialectOperation;
import org.hibernate.ogm.compensation.operation.InsertOrUpdateTuple;
import org.hibernate.ogm.compensation.operation.UpdateTupleWithOptimisticLock;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.optimisticlock.spi.OptimisticLockingAwareGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.model.impl.DefaultEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.TestHelper;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA}, comment="Cassandra always upserts, doesn't read-lock before write, doesn't support unique constraints even on primary key except by explicit/slow CAS use")
public class CompensationSpiTest
extends OgmTestCase {
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ogm-test-thread-%d").build();
        executor = Executors.newSingleThreadExecutor(threadFactory);
    }

    @Test
    public void onRollbackPresentsAppliedInsertOperations() {
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        session.persist((Object)new Shipment("shipment-1", "INITIAL"));
        session.persist((Object)new Shipment("shipment-2", "INITIAL"));
        session.flush();
        session.clear();
        try {
            session.persist((Object)new Shipment("shipment-1", "INITIAL"));
            session.getTransaction().commit();
        }
        catch (Exception e) {
            this.rollbackTransactionIfActive(session.getTransaction());
        }
        Iterator<ErrorHandler.RollbackContext> onRollbackInvocations = InvocationTrackingHandler.INSTANCE.getOnRollbackInvocations().iterator();
        Iterator appliedOperations = onRollbackInvocations.next().getAppliedGridDialectOperations().iterator();
        Assertions.assertThat((boolean)onRollbackInvocations.hasNext()).isFalse();
        if (this.currentDialectHasFacet(BatchableGridDialect.class) || this.currentDialectHasFacet(GroupingByEntityDialect.class)) {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            GridDialectOperation operation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)operation).isInstanceOf(ExecuteBatch.class);
            ExecuteBatch batch = (ExecuteBatch)operation.as(ExecuteBatch.class);
            Iterator batchedOperations = batch.getOperations().iterator();
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat((boolean)batchedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
        }
        if (this.currentDialectUsesLookupDuplicatePreventionStrategy()) {
            Assertions.assertThat((boolean)appliedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
        }
        session.close();
    }

    @Test
    public void onRollbackPresentsAppliedInsertOperationsForSave() {
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        session.persist((Object)new Shipment("shipment-1", "INITIAL"));
        session.persist((Object)new Shipment("shipment-2", "INITIAL"));
        session.flush();
        session.clear();
        try {
            session.save((Object)new Shipment("shipment-1", "INITIAL"));
            session.getTransaction().commit();
        }
        catch (Exception e) {
            this.rollbackTransactionIfActive(session.getTransaction());
        }
        Iterator<ErrorHandler.RollbackContext> onRollbackInvocations = InvocationTrackingHandler.INSTANCE.getOnRollbackInvocations().iterator();
        Iterator appliedOperations = onRollbackInvocations.next().getAppliedGridDialectOperations().iterator();
        Assertions.assertThat((boolean)onRollbackInvocations.hasNext()).isFalse();
        if (this.currentDialectHasFacet(BatchableGridDialect.class) || this.currentDialectHasFacet(GroupingByEntityDialect.class)) {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(ExecuteBatch.class);
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
        }
        if (this.currentDialectUsesLookupDuplicatePreventionStrategy()) {
            Assertions.assertThat((boolean)appliedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void onRollbackPresentsAppliedUpdateOperations() throws Exception {
        GridDialectOperation appliedOperation;
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        Shipment shipment1 = new Shipment("shipment-1", "INITIAL");
        session.persist((Object)shipment1);
        Shipment shipment2 = new Shipment("shipment-2", "INITIAL");
        session.persist((Object)shipment2);
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        try {
            Shipment loadedShipment1 = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-1"));
            Shipment loadedShipment2 = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-2"));
            Future<?> future = this.updateShipmentInConcurrentThread("shipment-2", "PROCESSING");
            future.get();
            loadedShipment1.setState("PROCESSING");
            loadedShipment2.setState("PROCESSING");
            session.getTransaction().commit();
            Fail.fail((String)"expected exception was not raised");
        }
        catch (StaleObjectStateException loadedShipment1) {
        }
        finally {
            this.rollbackTransactionIfActive(session.getTransaction());
            session.close();
        }
        Iterator<ErrorHandler.RollbackContext> onRollbackInvocations = InvocationTrackingHandler.INSTANCE.getOnRollbackInvocations().iterator();
        Iterator appliedOperations = onRollbackInvocations.next().getAppliedGridDialectOperations().iterator();
        Assertions.assertThat((boolean)onRollbackInvocations.hasNext()).isFalse();
        if (this.currentDialectHasFacet(OptimisticLockingAwareGridDialect.class)) {
            appliedOperation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)appliedOperation).isInstanceOf(UpdateTupleWithOptimisticLock.class);
            UpdateTupleWithOptimisticLock updateTupleWithOptimisticLock = (UpdateTupleWithOptimisticLock)appliedOperation.as(UpdateTupleWithOptimisticLock.class);
            Assertions.assertThat((String)updateTupleWithOptimisticLock.getEntityKey().getTable()).isEqualTo((Object)"Shipment");
            Assertions.assertThat((Object[])updateTupleWithOptimisticLock.getEntityKey().getColumnValues()).isEqualTo(new Object[]{"shipment-1"});
        } else if (this.currentDialectHasFacet(GroupingByEntityDialect.class)) {
            GridDialectOperation operation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)operation).isInstanceOf(ExecuteBatch.class);
            ExecuteBatch batch = (ExecuteBatch)operation.as(ExecuteBatch.class);
            Iterator batchedOperations = batch.getOperations().iterator();
            InsertOrUpdateTuple insertOrUpdate = (InsertOrUpdateTuple)((GridDialectOperation)batchedOperations.next()).as(InsertOrUpdateTuple.class);
            Assertions.assertThat((String)insertOrUpdate.getEntityKey().getTable()).isEqualTo((Object)"Shipment");
            Assertions.assertThat((Object[])insertOrUpdate.getEntityKey().getColumnValues()).isEqualTo(new Object[]{"shipment-1"});
            Assertions.assertThat((boolean)batchedOperations.hasNext()).isFalse();
        } else {
            appliedOperation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)appliedOperation).isInstanceOf(InsertOrUpdateTuple.class);
            InsertOrUpdateTuple insertOrUpdate = (InsertOrUpdateTuple)appliedOperation.as(InsertOrUpdateTuple.class);
            Assertions.assertThat((String)insertOrUpdate.getEntityKey().getTable()).isEqualTo((Object)"Shipment");
            Assertions.assertThat((Object[])insertOrUpdate.getEntityKey().getColumnValues()).isEqualTo(new Object[]{"shipment-1"});
        }
        Assertions.assertThat((boolean)appliedOperations.hasNext()).isFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SkipByGridDialect(value={GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE, GridDialectType.INFINISPAN, GridDialectType.EHCACHE}, comment="Can use parallel local TX not with JTA")
    public void appliedOperationsPassedToErrorHandlerAreSeparatedByTransaction() throws Exception {
        GridDialectOperation appliedOperation;
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        session.persist((Object)new Shipment("shipment-1", "INITIAL"));
        session.persist((Object)new Shipment("shipment-2", "INITIAL"));
        session.persist((Object)new Shipment("shipment-3", "INITIAL"));
        session.getTransaction().commit();
        session.close();
        OgmSession sessionA = this.openSession();
        sessionA.getTransaction().begin();
        OgmSession sessionB = this.openSession();
        sessionB.getTransaction().begin();
        try {
            Shipment loadedShipment1A = (Shipment)sessionA.get(Shipment.class, (Serializable)((Object)"shipment-1"));
            Shipment loadedShipment2B = (Shipment)sessionB.get(Shipment.class, (Serializable)((Object)"shipment-2"));
            Shipment loadedShipment3B = (Shipment)sessionB.get(Shipment.class, (Serializable)((Object)"shipment-3"));
            Future<?> future = this.updateShipmentInConcurrentThread("shipment-3", "PROCESSING");
            future.get();
            loadedShipment1A.setState("PROCESSING");
            sessionA.flush();
            loadedShipment2B.setState("PROCESSING");
            loadedShipment3B.setState("PROCESSING");
            sessionA.getTransaction().commit();
            sessionB.getTransaction().commit();
            Fail.fail((String)"expected exception was not raised");
        }
        catch (StaleObjectStateException loadedShipment1A) {
        }
        finally {
            this.rollbackTransactionIfActive(sessionA.getTransaction());
            this.rollbackTransactionIfActive(sessionB.getTransaction());
            sessionA.close();
            sessionB.close();
        }
        Iterator<ErrorHandler.RollbackContext> onRollbackInvocations = InvocationTrackingHandler.INSTANCE.getOnRollbackInvocations().iterator();
        Iterator appliedOperations = onRollbackInvocations.next().getAppliedGridDialectOperations().iterator();
        Assertions.assertThat((boolean)onRollbackInvocations.hasNext()).isFalse();
        if (this.currentDialectHasFacet(OptimisticLockingAwareGridDialect.class)) {
            appliedOperation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)appliedOperation).isInstanceOf(UpdateTupleWithOptimisticLock.class);
            UpdateTupleWithOptimisticLock updateTupleWithOptimisticLock = (UpdateTupleWithOptimisticLock)appliedOperation.as(UpdateTupleWithOptimisticLock.class);
            Assertions.assertThat((String)updateTupleWithOptimisticLock.getEntityKey().getTable()).isEqualTo((Object)"Shipment");
            Assertions.assertThat((Object[])updateTupleWithOptimisticLock.getEntityKey().getColumnValues()).isEqualTo(new Object[]{"shipment-2"});
        } else if (this.currentDialectHasFacet(GroupingByEntityDialect.class)) {
            GridDialectOperation operation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)operation).isInstanceOf(ExecuteBatch.class);
            ExecuteBatch batch = (ExecuteBatch)operation.as(ExecuteBatch.class);
            Iterator batchedOperations = batch.getOperations().iterator();
            InsertOrUpdateTuple insertOrUpdate = (InsertOrUpdateTuple)((GridDialectOperation)batchedOperations.next()).as(InsertOrUpdateTuple.class);
            Assertions.assertThat((String)insertOrUpdate.getEntityKey().getTable()).isEqualTo((Object)"Shipment");
            Assertions.assertThat((Object[])insertOrUpdate.getEntityKey().getColumnValues()).isEqualTo(new Object[]{"shipment-2"});
            Assertions.assertThat((boolean)batchedOperations.hasNext()).isFalse();
        } else {
            appliedOperation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)appliedOperation).isInstanceOf(InsertOrUpdateTuple.class);
            InsertOrUpdateTuple insertOrUpdate = (InsertOrUpdateTuple)appliedOperation.as(InsertOrUpdateTuple.class);
            Assertions.assertThat((String)insertOrUpdate.getEntityKey().getTable()).isEqualTo((Object)"Shipment");
            Assertions.assertThat((Object[])insertOrUpdate.getEntityKey().getColumnValues()).isEqualTo(new Object[]{"shipment-2"});
        }
    }

    @Test
    public void onFailedOperationPresentsFailedAndAppliedOperationsAndException() {
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        session.persist((Object)new Shipment("shipment-1", "INITIAL"));
        session.persist((Object)new Shipment("shipment-2", "INITIAL"));
        session.flush();
        session.clear();
        try {
            session.persist((Object)new Shipment("shipment-1", "INITIAL"));
            session.getTransaction().commit();
            Fail.fail((String)"Expected exception was not raised");
        }
        catch (Exception e) {
            this.rollbackTransactionIfActive(session.getTransaction());
        }
        Iterator<ErrorHandler.FailedGridDialectOperationContext> onFailedOperationInvocations = InvocationTrackingHandler.INSTANCE.getOnFailedOperationInvocations().iterator();
        ErrorHandler.FailedGridDialectOperationContext invocation = onFailedOperationInvocations.next();
        Assertions.assertThat((boolean)onFailedOperationInvocations.hasNext()).isFalse();
        if ((this.currentDialectHasFacet(BatchableGridDialect.class) || this.currentDialectHasFacet(GroupingByEntityDialect.class)) && !this.currentDialectUsesLookupDuplicatePreventionStrategy()) {
            Assertions.assertThat((Object)invocation.getFailedOperation()).isInstanceOf(ExecuteBatch.class);
        } else {
            Assertions.assertThat((Object)invocation.getFailedOperation()).isInstanceOf(InsertOrUpdateTuple.class);
        }
        Assertions.assertThat((Throwable)invocation.getException()).isExactlyInstanceOf(TupleAlreadyExistsException.class);
        Iterator appliedOperations = invocation.getAppliedGridDialectOperations().iterator();
        if (this.currentDialectHasFacet(BatchableGridDialect.class) || this.currentDialectHasFacet(GroupingByEntityDialect.class)) {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            GridDialectOperation operation = (GridDialectOperation)appliedOperations.next();
            Assertions.assertThat((Object)operation).isInstanceOf(ExecuteBatch.class);
            ExecuteBatch batch = (ExecuteBatch)operation.as(ExecuteBatch.class);
            Iterator batchedOperations = batch.getOperations().iterator();
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(batchedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat((boolean)batchedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(InsertOrUpdateTuple.class);
        }
        if (this.currentDialectUsesLookupDuplicatePreventionStrategy()) {
            Assertions.assertThat((boolean)appliedOperations.hasNext()).isFalse();
        } else {
            Assertions.assertThat(appliedOperations.next()).isInstanceOf(CreateTupleWithKey.class);
        }
        session.close();
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Transaction cannot be committed when continuing after an exception ")
    public void subsequentOperationsArePerformedForErrorHandlingStrategyContinue() {
        OgmSessionFactory sessionFactory = TestHelper.getDefaultTestSessionFactory(Collections.singletonMap("hibernate.ogm.error_handler", ContinuingErrorHandler.INSTANCE), this.getAnnotatedClasses());
        OgmSession session = sessionFactory.openSession();
        session.getTransaction().begin();
        session.persist((Object)new Shipment("shipment-1", "INITIAL"));
        session.persist((Object)new Shipment("shipment-2", "INITIAL"));
        session.flush();
        session.clear();
        session.persist((Object)new Shipment("shipment-1", "INITIAL"));
        session.flush();
        session.persist((Object)new Shipment("shipment-3", "INITIAL"));
        session.getTransaction().commit();
        session.close();
        session = sessionFactory.openSession();
        session.getTransaction().begin();
        Shipment loadedShipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-1"));
        Assertions.assertThat((Object)loadedShipment).isNotNull();
        loadedShipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-2"));
        Assertions.assertThat((Object)loadedShipment).isNotNull();
        loadedShipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-3"));
        Assertions.assertThat((Object)loadedShipment).isNotNull();
        session.getTransaction().commit();
        session.close();
    }

    private Future<?> updateShipmentInConcurrentThread(final String id, final String newState) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                OgmSession session = CompensationSpiTest.this.openSession();
                session.getTransaction().begin();
                Shipment shipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)id));
                shipment.setState(newState);
                session.getTransaction().commit();
                session.close();
            }
        });
    }

    @After
    public void deleteTestDataAndResetErrorHandler() {
        OgmSession session = this.openSession();
        session.getTransaction().begin();
        Shipment shipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-1"));
        if (shipment != null) {
            session.delete((Object)shipment);
        }
        if ((shipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-2"))) != null) {
            session.delete((Object)shipment);
        }
        if ((shipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-3"))) != null) {
            session.delete((Object)shipment);
        }
        if ((shipment = (Shipment)session.get(Shipment.class, (Serializable)((Object)"shipment-4"))) != null) {
            session.delete((Object)shipment);
        }
        session.getTransaction().commit();
        session.close();
        InvocationTrackingHandler.INSTANCE.clear();
    }

    @Override
    protected void configure(Map<String, Object> settings) {
        settings.put("hibernate.ogm.error_handler", InvocationTrackingHandler.INSTANCE);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Shipment.class};
    }

    private boolean currentDialectHasFacet(Class<? extends GridDialect> facet) {
        GridDialect gridDialect = (GridDialect)this.getSessionFactory().getServiceRegistry().getService(GridDialect.class);
        return GridDialects.hasFacet((GridDialect)gridDialect, facet);
    }

    private boolean currentDialectUsesLookupDuplicatePreventionStrategy() {
        GridDialect gridDialect = (GridDialect)this.getSessionFactory().getServiceRegistry().getService(GridDialect.class);
        DefaultEntityKeyMetadata ekm = new DefaultEntityKeyMetadata("Shipment", new String[]{"id"});
        return gridDialect.getDuplicateInsertPreventionStrategy((EntityKeyMetadata)ekm) == DuplicateInsertPreventionStrategy.LOOK_UP;
    }

    private void rollbackTransactionIfActive(Transaction transaction) {
        if (transaction.getStatus() == TransactionStatus.ACTIVE) {
            transaction.rollback();
        }
    }
}

