/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.compensation;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.ogm.compensation.ErrorHandler;
import org.hibernate.ogm.compensation.ErrorHandlingStrategy;

class InvocationTrackingHandler
implements ErrorHandler {
    static InvocationTrackingHandler INSTANCE = new InvocationTrackingHandler();
    private final List<ErrorHandler.RollbackContext> onRollbackInvocations = new ArrayList<ErrorHandler.RollbackContext>();
    private final List<ErrorHandler.FailedGridDialectOperationContext> onFailedOperationInvocations = new ArrayList<ErrorHandler.FailedGridDialectOperationContext>();

    private InvocationTrackingHandler() {
    }

    public void onRollback(ErrorHandler.RollbackContext context) {
        this.onRollbackInvocations.add(context);
    }

    public ErrorHandlingStrategy onFailedGridDialectOperation(ErrorHandler.FailedGridDialectOperationContext context) {
        this.onFailedOperationInvocations.add(context);
        return ErrorHandlingStrategy.ABORT;
    }

    public void clear() {
        this.onRollbackInvocations.clear();
        this.onFailedOperationInvocations.clear();
    }

    public List<ErrorHandler.RollbackContext> getOnRollbackInvocations() {
        return this.onRollbackInvocations;
    }

    public List<ErrorHandler.FailedGridDialectOperationContext> getOnFailedOperationInvocations() {
        return this.onFailedOperationInvocations;
    }
}

