/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.dialectinvocations;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.collection.types.GrandChild;
import org.hibernate.ogm.backendtck.associations.collection.types.GrandMother;
import org.hibernate.ogm.backendtck.dialectinvocations.AbstractGridDialectOperationInvocationsTest;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.NEO4J_REMOTE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.REDIS_HASH, GridDialectType.INFINISPAN_REMOTE}, comment="For Neo4j, the getAssociation always return an association, thus we don't have the createAssociation call. Redis Hash is just weird. Infinispan Remote needs to be investigated.")
public class GridDialectOperationInvocationsForElementCollectionTest
extends AbstractGridDialectOperationInvocationsTest {
    @Test
    public void testEmbeddableCollectionAsList() throws Exception {
        GridDialect gridDialect = this.getGridDialect();
        OgmSession session = this.openSession();
        Transaction tx = session.beginTransaction();
        GrandChild luke = new GrandChild();
        luke.setName("Luke");
        GrandChild leia = new GrandChild();
        leia.setName("Leia");
        GrandMother grandMother = new GrandMother();
        grandMother.getGrandChildren().add(luke);
        grandMother.getGrandChildren().add(leia);
        session.persist((Object)grandMother);
        tx.commit();
        if (GridDialects.hasFacet((GridDialect)gridDialect, GroupingByEntityDialect.class)) {
            if (this.isDuplicateInsertPreventionStrategyNative(gridDialect)) {
                Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"createTuple", "getAssociation", "createAssociation", "executeBatch[group[insertOrUpdateTuple,insertOrUpdateAssociation]]"});
            } else {
                Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "createTuple", "getAssociation", "createAssociation", "executeBatch[group[insertOrUpdateTuple,insertOrUpdateAssociation]]"});
            }
        } else if (GridDialects.hasFacet((GridDialect)gridDialect, BatchableGridDialect.class)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"createTuple", "getAssociation", "executeBatch[group[insertOrUpdateTuple,insertOrUpdateAssociation]]"});
        } else if (this.isDuplicateInsertPreventionStrategyNative(gridDialect)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"createTuple", "insertOrUpdateTuple", "getAssociation", "createAssociation", "insertOrUpdateAssociation"});
        } else {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "createTuple", "insertOrUpdateTuple", "getAssociation", "createAssociation", "insertOrUpdateAssociation"});
        }
        session.clear();
        this.resetOperationsLog();
        tx = session.beginTransaction();
        grandMother = (GrandMother)session.get(GrandMother.class, (Serializable)((Object)grandMother.getId()));
        grandMother.getGrandChildren().remove(0);
        tx.commit();
        session.clear();
        if (GridDialects.hasFacet((GridDialect)gridDialect, GroupingByEntityDialect.class) || GridDialects.hasFacet((GridDialect)gridDialect, BatchableGridDialect.class)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getAssociation", "executeBatch[group[insertOrUpdateAssociation,insertOrUpdateAssociation,insertOrUpdateAssociation]]"});
        } else if (this.isDuplicateInsertPreventionStrategyNative(gridDialect)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getAssociation", "insertOrUpdateAssociation", "insertOrUpdateAssociation"});
        } else {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getAssociation", "insertOrUpdateAssociation", "insertOrUpdateAssociation"});
        }
        this.resetOperationsLog();
        tx = session.beginTransaction();
        grandMother = (GrandMother)session.get(GrandMother.class, (Serializable)((Object)grandMother.getId()));
        Assertions.assertThat(grandMother.getGrandChildren()).onProperty("name").containsExactly(new Object[]{"Leia"});
        session.delete((Object)grandMother);
        tx.commit();
        if (GridDialects.hasFacet((GridDialect)gridDialect, GroupingByEntityDialect.class) || GridDialects.hasFacet((GridDialect)gridDialect, BatchableGridDialect.class)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getAssociation", "executeBatch[group[removeAssociation],removeTuple]"});
        } else if (this.isDuplicateInsertPreventionStrategyNative(gridDialect)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getAssociation", "removeAssociation", "removeTuple"});
        } else {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getAssociation", "removeAssociation", "removeTuple"});
        }
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{GrandMother.class, GrandChild.class};
    }
}

