/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.dialectinvocations;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.associations.onetoone.Husband;
import org.hibernate.ogm.backendtck.associations.onetoone.Wife;
import org.hibernate.ogm.backendtck.dialectinvocations.AbstractGridDialectOperationInvocationsTest;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.NEO4J_REMOTE, GridDialectType.NEO4J_EMBEDDED, GridDialectType.REDIS_HASH, GridDialectType.INFINISPAN_REMOTE}, comment="For Cassandra and Neo4j, the getAssociation always return an association, thus we don't have the createAssociation call. Redis Hash is just weird. Infinispan Remote needs to be investigated.")
public class GridDialectOperationInvocationsForOneToOneTest
extends AbstractGridDialectOperationInvocationsTest {
    @Test
    public void testBidirectionalOneToOne() throws Exception {
        GridDialect gridDialect = this.getGridDialect();
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Husband husband = new Husband("alex");
        husband.setName("Alex");
        Wife wife = new Wife("bea");
        wife.setName("Bea");
        husband.setWife(wife);
        wife.setHusband(husband);
        session.persist((Object)husband);
        session.persist((Object)wife);
        transaction.commit();
        session.clear();
        if (GridDialects.hasFacet((GridDialect)gridDialect, GroupingByEntityDialect.class)) {
            if (this.isDuplicateInsertPreventionStrategyNative(gridDialect)) {
                Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "createTuple", "createTuple", "getAssociation", "createAssociation", "executeBatch[group[insertOrUpdateTuple,insertOrUpdateTuple],group[insertOrUpdateTuple,insertOrUpdateAssociation]]"});
            } else {
                Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getTuple", "createTuple", "getTuple", "createTuple", "getAssociation", "createAssociation", "executeBatch[group[insertOrUpdateTuple,insertOrUpdateTuple],group[insertOrUpdateTuple,insertOrUpdateAssociation]]"});
            }
        } else if (GridDialects.hasFacet((GridDialect)gridDialect, BatchableGridDialect.class)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "createTuple", "createTuple", "getAssociation", "createAssociation", "executeBatch[group[insertOrUpdateAssociation]]"});
        } else if (this.isDuplicateInsertPreventionStrategyNative(gridDialect)) {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "createTuple", "insertOrUpdateTuple", "createTuple", "insertOrUpdateTuple", "insertOrUpdateTuple", "getAssociation", "createAssociation", "insertOrUpdateAssociation"});
        } else {
            Assertions.assertThat(this.getOperations()).containsExactly(new Object[]{"getTuple", "getTuple", "createTuple", "insertOrUpdateTuple", "getTuple", "createTuple", "insertOrUpdateTuple", "insertOrUpdateTuple", "getAssociation", "createAssociation", "insertOrUpdateAssociation"});
        }
        transaction = session.beginTransaction();
        husband = (Husband)session.get(Husband.class, (Serializable)((Object)husband.getId()));
        session.clear();
        session.delete((Object)husband);
        session.delete((Object)husband.getWife());
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Husband.class, Wife.class};
    }
}

