/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.embeddable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.embeddable.AccountWithPhone;
import org.hibernate.ogm.backendtck.embeddable.Address;
import org.hibernate.ogm.backendtck.embeddable.AddressType;
import org.hibernate.ogm.backendtck.embeddable.MultiAddressAccount;
import org.hibernate.ogm.backendtck.embeddable.Order;
import org.hibernate.ogm.backendtck.embeddable.PhoneNumber;
import org.hibernate.ogm.backendtck.embeddable.ShippingAddress;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA, GridDialectType.INFINISPAN_REMOTE}, comment="POJOs contain lists - bag semantics unsupported (no primary key)")
public class EmbeddableExtraTest
extends OgmTestCase {
    @Test
    public void testElementCollectionOfEmbeddable() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Address address = new Address();
        address.setCity("Paris");
        address.setCountry("France");
        address.setStreet1("1 avenue des Champs Elysees");
        address.setZipCode("75007");
        Address anotherAddress = new Address();
        anotherAddress.setCity("Rome");
        anotherAddress.setCountry("Italy");
        anotherAddress.setStreet1("Piazza del Colosseo, 1");
        anotherAddress.setZipCode("00184");
        anotherAddress.setType(new AddressType("primary"));
        MultiAddressAccount account = new MultiAddressAccount();
        account.setLogin("gunnar");
        account.setPassword("highly secret");
        account.getAddresses().add(address);
        account.getAddresses().add(anotherAddress);
        session.persist((Object)account);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        MultiAddressAccount loadedAccount = (MultiAddressAccount)session.get(MultiAddressAccount.class, (Serializable)((Object)account.getLogin()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedAccount).as("Cannot load persisted object")).isNotNull();
        Assertions.assertThat(loadedAccount.getAddresses()).onProperty("city").containsOnly(new Object[]{"Paris", "Rome"});
        Assertions.assertThat(loadedAccount.getAddresses()).onProperty("zipCode").containsOnly(new Object[]{"75007", "00184"});
        Assertions.assertThat(loadedAccount.getAddresses()).onProperty("country").containsOnly(new Object[]{"France", "Italy"});
        Assertions.assertThat(loadedAccount.getAddresses()).onProperty("street2").containsOnly(new Object[]{null, null});
        Assertions.assertThat(loadedAccount.getAddresses()).onProperty("type").containsOnly(new Object[]{new AddressType("primary"), null});
        Address loadedAddress1 = loadedAccount.getAddresses().get(0);
        Address loadedAddress2 = loadedAccount.getAddresses().get(1);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedAddress1.setCountry("USA");
        loadedAddress2.setCountry("Germany");
        session.merge((Object)loadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        MultiAddressAccount secondLoadedAccount = (MultiAddressAccount)session.get(MultiAddressAccount.class, (Serializable)((Object)account.getLogin()));
        Assertions.assertThat(secondLoadedAccount.getAddresses()).onProperty("city").contains(new Object[]{"Paris", "Rome"});
        Assertions.assertThat(secondLoadedAccount.getAddresses()).onProperty("country").contains(new Object[]{"USA", "Germany"});
        session.delete((Object)secondLoadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(MultiAddressAccount.class, (Serializable)((Object)account.getLogin()))).isNull();
        transaction.commit();
        session.close();
    }

    @Test
    public void testPersistEmbeddedWithNullEmbeddedList() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        AccountWithPhone wombatSoftware = new AccountWithPhone("1", "Mobile account 1");
        wombatSoftware.setPhoneNumber(null);
        session.persist((Object)wombatSoftware);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        AccountWithPhone loadedUser = (AccountWithPhone)session.get(AccountWithPhone.class, (Serializable)((Object)wombatSoftware.getId()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedUser).as("Cannot load persisted object with nested embeddables")).isNotNull();
        Assertions.assertThat((Object)loadedUser.getPhoneNumber()).isNotNull();
        Assertions.assertThat((String)loadedUser.getPhoneNumber().getMain()).isNull();
        Assertions.assertThat(loadedUser.getPhoneNumber().getAlternatives()).isEmpty();
        session.delete((Object)loadedUser);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(AccountWithPhone.class, (Serializable)((Object)wombatSoftware.getId()))).isNull();
        transaction.commit();
        session.close();
    }

    @Test
    public void testPersistWithEmbeddedList() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        List<String> alternativePhones = Arrays.asList("+1-222-555-0222", "+1-202-555-0333");
        AccountWithPhone account = new AccountWithPhone("2", "Mobile account 2");
        account.setPhoneNumber(new PhoneNumber("+1-222-555-0111", alternativePhones));
        session.persist((Object)account);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        AccountWithPhone loadedUser = (AccountWithPhone)session.get(AccountWithPhone.class, (Serializable)((Object)account.getId()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedUser).as("Cannot load persisted object with nested embeddables")).isNotNull();
        Assertions.assertThat((Object)loadedUser.getPhoneNumber()).isNotNull();
        Assertions.assertThat((String)loadedUser.getPhoneNumber().getMain()).isEqualTo((Object)account.getPhoneNumber().getMain());
        Assertions.assertThat(loadedUser.getPhoneNumber().getAlternatives()).containsOnly(alternativePhones.toArray(new Object[alternativePhones.size()]));
        session.delete((Object)loadedUser);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(AccountWithPhone.class, (Serializable)((Object)account.getId()))).isNull();
        transaction.commit();
        session.close();
    }

    @Test
    public void testPersistWithListEmbeddedInNestedComponent() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Order order = new Order("order-1", "Telescope", new ShippingAddress(new PhoneNumber("+1-222-555-0111", Arrays.asList("+1-222-555-0222", "+1-202-555-0333")), "Planet road 68"));
        session.persist((Object)order);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Order loadedOrder = (Order)session.get(Order.class, (Serializable)((Object)"order-1"));
        ((ObjectAssert)Assertions.assertThat((Object)loadedOrder).as("Cannot load persisted object with nested embeddables")).isNotNull();
        Assertions.assertThat((Object)loadedOrder.getShippingAddress()).isNotNull();
        Assertions.assertThat((Object)loadedOrder.getShippingAddress().getPhone()).isNotNull();
        Assertions.assertThat((String)loadedOrder.getShippingAddress().getPhone().getMain()).isEqualTo((Object)"+1-222-555-0111");
        Assertions.assertThat(loadedOrder.getShippingAddress().getPhone().getAlternatives()).containsOnly(new Object[]{"+1-222-555-0222", "+1-202-555-0333"});
        session.delete((Object)loadedOrder);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(Order.class, (Serializable)((Object)"order-1"))).isNull();
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{MultiAddressAccount.class, AccountWithPhone.class, Order.class};
    }
}

