/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.embeddable;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.embeddable.Account;
import org.hibernate.ogm.backendtck.embeddable.Address;
import org.hibernate.ogm.backendtck.embeddable.AddressType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Test;

public class EmbeddableTest
extends OgmTestCase {
    @Test
    public void testEmbeddable() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Account account = new Account();
        account.setLogin("emmanuel");
        account.setPassword("like I would tell ya");
        account.setHomeAddress(new Address());
        Address address = account.getHomeAddress();
        address.setCity("Paris");
        address.setCountry("France");
        address.setStreet1("1 avenue des Champs Elysees");
        address.setZipCode("75007");
        session.persist((Object)account);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Account loadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedAccount).as("Cannot load persisted object")).isNotNull();
        Address loadedAddress = loadedAccount.getHomeAddress();
        ((ObjectAssert)Assertions.assertThat((Object)loadedAddress).as("Embeddable should not be null")).isNotNull();
        ((StringAssert)Assertions.assertThat((String)loadedAddress.getCity()).as("persist and load fails for embeddable")).isEqualTo((Object)address.getCity());
        ((StringAssert)Assertions.assertThat((String)loadedAddress.getZipCode()).as("@Column support for embeddable does not work")).isEqualTo((Object)address.getZipCode());
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedAddress.setCountry("USA");
        session.merge((Object)loadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Account secondLoadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((StringAssert)Assertions.assertThat((String)loadedAccount.getHomeAddress().getCity()).as("Merge fails for embeddable")).isEqualTo((Object)secondLoadedAccount.getHomeAddress().getCity());
        session.delete((Object)secondLoadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(Account.class, (Serializable)((Object)account.getLogin()))).isNull();
        transaction.commit();
        session.close();
    }

    @Test
    public void testNestedEmbeddable() {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Account account = new Account();
        account.setLogin("gunnar");
        session.persist((Object)account);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Account loadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedAccount).as("Cannot load persisted object with nested embeddables which are null")).isNotNull();
        Assertions.assertThat((Object)loadedAccount.getHomeAddress()).isNull();
        loadedAccount.setHomeAddress(new Address());
        loadedAccount.getHomeAddress().setCity("Lima");
        loadedAccount.getHomeAddress().setType(new AddressType("primary"));
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedAccount).as("Cannot load persisted object with nested embeddables")).isNotNull();
        Assertions.assertThat((Object)loadedAccount.getHomeAddress()).isNotNull();
        Assertions.assertThat((String)loadedAccount.getHomeAddress().getCity()).isEqualTo((Object)"Lima");
        Assertions.assertThat((Object)loadedAccount.getHomeAddress().getType()).isNotNull();
        Assertions.assertThat((String)loadedAccount.getHomeAddress().getType().getName()).isEqualTo((Object)"primary");
        session.delete((Object)loadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(Account.class, (Serializable)((Object)account.getLogin()))).isNull();
        transaction.commit();
        session.close();
    }

    @Test
    public void testNestedEmbeddedWithNullProperties() {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Account account = new Account();
        account.setLogin("gunnar");
        account.setHomeAddress(new Address());
        account.getHomeAddress().setCity("Lima");
        account.getHomeAddress().setType(new AddressType("primary"));
        session.persist((Object)account);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Account loadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        loadedAccount.getHomeAddress().setType(null);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedAccount).as("Cannot load persisted object with nested embeddables")).isNotNull();
        Assertions.assertThat((Object)loadedAccount.getHomeAddress()).isNotNull();
        Assertions.assertThat((Object)loadedAccount.getHomeAddress().getType()).isNull();
        loadedAccount.setHomeAddress(null);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedAccount).as("Cannot load persisted object with nested embeddables")).isNotNull();
        Assertions.assertThat((Object)loadedAccount.getHomeAddress()).isNull();
        session.delete((Object)loadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(Account.class, (Serializable)((Object)account.getLogin()))).isNull();
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Account.class};
    }
}

