/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.hibernatecore;

import javax.naming.Reference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.hibernatecore.Contact;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryObjectFactory;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionImpl;
import org.hibernate.ogm.utils.PackagingRule;
import org.hibernate.ogm.utils.TestHelper;
import org.junit.Rule;
import org.junit.Test;

public class HibernateCoreAPIWrappingTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/ogm.xml", Contact.class);

    @Test
    public void testWrappedFromEntityManagerAPI() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"ogm", TestHelper.getDefaultTestSettings());
        Assertions.assertThat((boolean)HibernateEntityManagerFactory.class.isAssignableFrom(emf.getClass())).isTrue();
        SessionFactoryImplementor factory = ((HibernateEntityManagerFactory)emf).getSessionFactory();
        Assertions.assertThat(factory.getClass()).isEqualTo(OgmSessionFactoryImpl.class);
        Session s = factory.openSession();
        Assertions.assertThat(s.getClass()).isEqualTo(OgmSessionImpl.class);
        Assertions.assertThat(s.getSessionFactory().getClass()).isEqualTo(OgmSessionFactoryImpl.class);
        s.close();
        EntityManager em = emf.createEntityManager();
        Assertions.assertThat((boolean)(em.unwrap(Session.class) instanceof OgmSession));
        Assertions.assertThat(em.getDelegate().getClass()).isEqualTo(OgmSessionImpl.class);
        em.close();
        emf.close();
    }

    @Test
    public void testJNDIReference() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"ogm", TestHelper.getDefaultTestSettings());
        SessionFactoryImplementor factory = ((HibernateEntityManagerFactory)emf).getSessionFactory();
        Reference reference = factory.getReference();
        Assertions.assertThat((String)reference.getClassName()).isEqualTo((Object)OgmSessionFactoryImpl.class.getName());
        Assertions.assertThat((String)reference.getFactoryClassName()).isEqualTo((Object)OgmSessionFactoryObjectFactory.class.getName());
        Assertions.assertThat((Object)reference.get(0)).isNotNull();
        Assertions.assertThat((String)reference.getFactoryClassLocation()).isNull();
        OgmSessionFactoryObjectFactory objFactory = new OgmSessionFactoryObjectFactory();
        SessionFactory factoryFromRegistry = (SessionFactory)objFactory.getObjectInstance((Object)reference, null, null, null);
        Assertions.assertThat(factoryFromRegistry.getClass()).isEqualTo(OgmSessionFactoryImpl.class);
        Assertions.assertThat((Object)factoryFromRegistry.getReference()).isEqualTo((Object)factory.getReference());
        emf.close();
    }
}

