/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.hibernatecore;

import javax.naming.Reference;
import org.fest.assertions.Assertions;
import org.hibernate.SessionFactory;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.hibernatecore.Contact;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryObjectFactory;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Test;

public class JNDIReferenceTest
extends OgmTestCase {
    @Test
    public void testGetReferenceImplementation() throws Exception {
        OgmSession session = this.openSession();
        SessionFactory factory = session.getSessionFactory();
        Assertions.assertThat(factory.getClass()).isEqualTo(OgmSessionFactoryImpl.class);
        Reference reference = factory.getReference();
        Assertions.assertThat((String)reference.getClassName()).isEqualTo((Object)OgmSessionFactoryImpl.class.getName());
        Assertions.assertThat((String)reference.getFactoryClassName()).isEqualTo((Object)OgmSessionFactoryObjectFactory.class.getName());
        Assertions.assertThat((Object)reference.get(0)).isNotNull();
        Assertions.assertThat((String)reference.getFactoryClassLocation()).isNull();
        OgmSessionFactoryObjectFactory objFactory = new OgmSessionFactoryObjectFactory();
        SessionFactory factoryFromRegistry = (SessionFactory)objFactory.getObjectInstance((Object)reference, null, null, null);
        Assertions.assertThat(factoryFromRegistry.getClass()).isEqualTo(OgmSessionFactoryImpl.class);
        Assertions.assertThat((Object)factoryFromRegistry.getReference()).isEqualTo((Object)factory.getReference());
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Contact.class};
    }
}

