/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.hsearch;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.ogm.backendtck.hsearch.Insurance;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Neo4j is not compatible with HSEARCH 5")
public class HibernateSearchAtopOgmTest
extends OgmJpaTestCase {
    @Test
    public void testHibernateSearchJPAAPIUsage() throws Exception {
        FullTextEntityManager ftem = Search.getFullTextEntityManager((EntityManager)this.getFactory().createEntityManager());
        ftem.getTransaction().begin();
        Insurance insurance = new Insurance();
        insurance.setName("Macif");
        ftem.persist((Object)insurance);
        ftem.getTransaction().commit();
        ftem.clear();
        ftem.getTransaction().begin();
        QueryBuilder b = ftem.getSearchFactory().buildQueryBuilder().forEntity(Insurance.class).get();
        Query lq = b.keyword().onField("name").matching((Object)"Macif").createQuery();
        FullTextQuery ftQuery = ftem.createFullTextQuery(lq, new Class[]{Insurance.class});
        List resultList = ftQuery.getResultList();
        Assertions.assertThat((boolean)this.getFactory().getPersistenceUnitUtil().isLoaded(resultList.get(0))).isTrue();
        Assertions.assertThat((List)resultList).hasSize(1);
        for (Object e : resultList) {
            ftem.remove(e);
        }
        ftem.getTransaction().commit();
        ftem.close();
    }

    @Test
    public void testHibernateSearchNativeAPIUsage() throws Exception {
        EntityManager entityManager = this.getFactory().createEntityManager();
        FullTextSession ftSession = org.hibernate.search.Search.getFullTextSession((Session)((Session)entityManager.unwrap(Session.class)));
        entityManager.getTransaction().begin();
        Insurance insurance = new Insurance();
        insurance.setName("Macif");
        ftSession.persist((Object)insurance);
        entityManager.getTransaction().commit();
        ftSession.clear();
        entityManager.getTransaction().begin();
        QueryBuilder b = ftSession.getSearchFactory().buildQueryBuilder().forEntity(Insurance.class).get();
        Query lq = b.keyword().onField("name").matching((Object)"Macif").createQuery();
        org.hibernate.search.FullTextQuery ftQuery = ftSession.createFullTextQuery(lq, new Class[]{Insurance.class});
        List resultList = ftQuery.list();
        Assertions.assertThat((boolean)this.getFactory().getPersistenceUnitUtil().isLoaded(resultList.get(0))).isTrue();
        Assertions.assertThat((List)resultList).hasSize(1);
        for (Object e : resultList) {
            ftSession.delete(e);
        }
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Insurance.class};
    }
}

