/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.hsearch;

import java.util.List;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.hsearch.Insurance;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.OgmTestCase;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.NEO4J_EMBEDDED, GridDialectType.NEO4J_REMOTE}, comment="Neo4j is not compatible with HSEARCH 5")
public class SearchOnStandaloneOGMTest
extends OgmTestCase {
    @Test
    public void testHibernateSearchJPAAPIUsage() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)session);
        Insurance insurance = new Insurance();
        insurance.setName("Macif");
        fts.persist((Object)insurance);
        transaction.commit();
        fts.clear();
        transaction = fts.beginTransaction();
        QueryBuilder b = fts.getSearchFactory().buildQueryBuilder().forEntity(Insurance.class).get();
        Query lq = b.keyword().onField("name").matching((Object)"Macif").createQuery();
        FullTextQuery ftQuery = fts.createFullTextQuery(lq, new Class[]{Insurance.class});
        List resultList = ftQuery.list();
        Assertions.assertThat((List)resultList).hasSize(1);
        for (Object e : resultList) {
            fts.delete(e);
        }
        transaction.commit();
        fts.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Insurance.class};
    }
}

