/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.id.DistributedRevisionControl;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AutoIdGeneratorTest
extends OgmJpaTestCase {
    private EntityManager em;

    @Before
    public void setUp() {
        this.em = this.getFactory().createEntityManager();
    }

    @After
    public void tearDown() {
        this.em.close();
    }

    @Test
    public void testAutoIdentifierGenerator() throws Exception {
        DistributedRevisionControl git = new DistributedRevisionControl();
        DistributedRevisionControl bzr = new DistributedRevisionControl();
        this.em.getTransaction().begin();
        git.setName("Git");
        this.em.persist((Object)git);
        bzr.setName("Bazaar");
        this.em.persist((Object)bzr);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        DistributedRevisionControl dvcs = (DistributedRevisionControl)this.em.find(DistributedRevisionControl.class, (Object)git.getId());
        Assertions.assertThat((Object)dvcs).isNotNull();
        Assertions.assertThat((Long)dvcs.getId()).isEqualTo(1L);
        this.em.remove((Object)dvcs);
        dvcs = (DistributedRevisionControl)this.em.find(DistributedRevisionControl.class, (Object)bzr.getId());
        Assertions.assertThat((Object)dvcs).isNotNull();
        Assertions.assertThat((Long)dvcs.getId()).isEqualTo(2L);
        this.em.getTransaction().commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{DistributedRevisionControl.class};
    }
}

