/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.id.DistributedRevisionControl;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Test;

public class AutoIdGeneratorWithSessionTest
extends OgmTestCase {
    @Test
    public void testAutoIdentifierGenerator() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        DistributedRevisionControl git = new DistributedRevisionControl();
        git.setName("Git");
        session.persist((Object)git);
        DistributedRevisionControl bzr = new DistributedRevisionControl();
        bzr.setName("Bazaar");
        session.persist((Object)bzr);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        DistributedRevisionControl dvcs = (DistributedRevisionControl)session.get(DistributedRevisionControl.class, (Serializable)git.getId());
        Assertions.assertThat((Object)dvcs).isNotNull();
        Assertions.assertThat((Long)dvcs.getId()).isEqualTo(1L);
        session.delete((Object)dvcs);
        dvcs = (DistributedRevisionControl)session.get(DistributedRevisionControl.class, (Serializable)bzr.getId());
        Assertions.assertThat((Object)dvcs).isNotNull();
        Assertions.assertThat((Long)dvcs.getId()).isEqualTo(2L);
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{DistributedRevisionControl.class};
    }
}

