/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.fest.assertions.Assertions;
import org.fest.assertions.StringAssert;
import org.hibernate.ogm.backendtck.id.MakeUpArtistId;
import org.hibernate.ogm.backendtck.id.MakeupArtist;
import org.hibernate.ogm.backendtck.id.MakeupArtistWithCompositeKey;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@SkipByGridDialect(value={GridDialectType.CASSANDRA}, comment="Cassandra always upserts, doesn't read-lock before write, doesn't support unique constraints even on primary key except by explicit/slow CAS use")
public class DuplicateIdDetectionTest
extends OgmJpaTestCase {
    EntityManager em;

    @Before
    public void setUp() {
        this.em = this.getFactory().createEntityManager();
    }

    @After
    public void tearDown() {
        this.em.close();
    }

    @Test
    public void cannotInsertSameEntityTwice() throws Exception {
        this.em.getTransaction().begin();
        MakeupArtist wibke = new MakeupArtist("wibke", "halloween");
        this.em.persist((Object)wibke);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        MakeupArtist notWibke = new MakeupArtist("wibke", "glamorous");
        this.em.persist((Object)notWibke);
        try {
            this.em.getTransaction().commit();
            Assert.fail((String)"Expected exception wasn't raised");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e.getCause()).isExactlyInstanceOf(PersistenceException.class);
            Assertions.assertThat((String)e.getCause().getMessage()).matches(".*OGM000067.*");
        }
        this.em.clear();
        this.em.getTransaction().begin();
        MakeupArtist loadedMakeupArtist = (MakeupArtist)this.em.find(MakeupArtist.class, (Object)"wibke");
        Assertions.assertThat((Object)loadedMakeupArtist).isNotNull();
        ((StringAssert)Assertions.assertThat((String)loadedMakeupArtist.getFavoriteStyle()).describedAs("Second insert should not be applied")).isEqualTo((Object)"halloween");
        this.em.remove((Object)loadedMakeupArtist);
        this.em.getTransaction().commit();
    }

    @Test
    public void cannotInsertSameEntityUsingCompositeKeyTwice() throws Exception {
        this.em.getTransaction().begin();
        MakeupArtistWithCompositeKey wibke = new MakeupArtistWithCompositeKey(new MakeUpArtistId("fancy-film", "wibke"), "halloween");
        this.em.persist((Object)wibke);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        MakeupArtistWithCompositeKey notWibke = new MakeupArtistWithCompositeKey(new MakeUpArtistId("fancy-film", "wibke"), "glamorous");
        this.em.persist((Object)notWibke);
        try {
            this.em.getTransaction().commit();
            Assert.fail((String)"Expected exception wasn't raised");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getCause().getMessage()).matches(".*OGM000067.*");
        }
        this.em.clear();
        this.em.getTransaction().begin();
        MakeupArtistWithCompositeKey loadedMakeupArtist = (MakeupArtistWithCompositeKey)this.em.find(MakeupArtistWithCompositeKey.class, (Object)new MakeUpArtistId("fancy-film", "wibke"));
        Assertions.assertThat((Object)loadedMakeupArtist).isNotNull();
        ((StringAssert)Assertions.assertThat((String)loadedMakeupArtist.getFavoriteStyle()).describedAs("Second insert should not be applied")).isEqualTo((Object)"halloween");
        this.em.remove((Object)loadedMakeupArtist);
        this.em.getTransaction().commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{MakeupArtist.class, MakeupArtistWithCompositeKey.class};
    }
}

