/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.HibernateException;
import org.hibernate.ogm.backendtck.id.Animal;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.hibernate.ogm.utils.Throwables;
import org.hibernate.ogm.utils.jpa.SingleJpaTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IdentityIdGeneratorTest
extends SingleJpaTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Override
    @Before
    public void createFactory() throws Throwable {
        this.thrown.expect(HibernateException.class);
        this.thrown.expectMessage("OGM000065");
        try {
            super.createFactory();
            Assert.fail((String)"Expected session factory set-up to fail as IDENTITY columns are not supported");
        }
        catch (Exception e) {
            throw Throwables.getRootCause(e);
        }
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.MONGODB}, comment="MongoDB supports IDENTITY columns, but not of type Long.")
    public void testIdentityGenerator() throws Exception {
        EntityManager em = this.getFactory().createEntityManager();
        em.getTransaction().begin();
        Animal jungleKing = new Animal();
        Animal fish = new Animal();
        jungleKing.setName("Lion");
        jungleKing.setSpecies("Mammal");
        em.persist((Object)jungleKing);
        fish.setName("Shark");
        fish.setSpecies("Tiger Shark");
        em.persist((Object)fish);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        Animal animal = (Animal)em.find(Animal.class, (Object)jungleKing.getId());
        Assertions.assertThat((Object)animal).isNotNull();
        Assertions.assertThat((Long)animal.getId()).isEqualTo(1L);
        Assertions.assertThat((String)animal.getName()).isEqualTo((Object)"Lion");
        em.remove((Object)animal);
        animal = (Animal)em.find(Animal.class, (Object)fish.getId());
        Assertions.assertThat((Object)animal).isNotNull();
        Assertions.assertThat((Long)animal.getId()).isEqualTo(2L);
        Assertions.assertThat((String)animal.getName()).isEqualTo((Object)"Shark");
        em.remove((Object)animal);
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{Animal.class};
    }
}

