/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.id.Actor;
import org.hibernate.ogm.backendtck.id.Song;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SequenceIdGeneratorTest
extends OgmJpaTestCase {
    private EntityManager em;

    @Before
    public void setUp() {
        this.em = this.getFactory().createEntityManager();
    }

    @After
    public void tearDown() {
        this.em.close();
    }

    @Test
    public void testSequenceIdGenerationInJTA() throws Exception {
        Song firstSong = new Song();
        Song secondSong = new Song();
        Actor firstActor = new Actor();
        Actor secondActor = new Actor();
        this.em.getTransaction().begin();
        firstSong.setSinger("Charlotte Church");
        firstSong.setTitle("Ave Maria");
        this.em.persist((Object)firstSong);
        secondSong.setSinger("Charlotte Church");
        secondSong.setTitle("Flower Duet");
        this.em.persist((Object)secondSong);
        firstActor.setName("Russell Crowe");
        firstActor.setBestMovieTitle("Gladiator");
        this.em.persist((Object)firstActor);
        secondActor.setName("Johnny Depp");
        secondActor.setBestMovieTitle("Pirates of the Caribbean");
        this.em.persist((Object)secondActor);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        firstSong = (Song)this.em.find(Song.class, (Object)firstSong.getId());
        Assertions.assertThat((Object)firstSong).isNotNull();
        Assertions.assertThat((Long)firstSong.getId()).isEqualTo(2L);
        Assertions.assertThat((String)firstSong.getTitle()).isEqualTo((Object)"Ave Maria");
        this.em.remove((Object)firstSong);
        secondSong = (Song)this.em.find(Song.class, (Object)secondSong.getId());
        Assertions.assertThat((Object)secondSong).isNotNull();
        Assertions.assertThat((Long)secondSong.getId()).isEqualTo(3L);
        Assertions.assertThat((String)secondSong.getTitle()).isEqualTo((Object)"Flower Duet");
        this.em.remove((Object)secondSong);
        firstActor = (Actor)this.em.find(Actor.class, (Object)firstActor.getId());
        Assertions.assertThat((Object)firstActor).isNotNull();
        Assertions.assertThat((Long)firstActor.getId()).isEqualTo(1L);
        Assertions.assertThat((String)firstActor.getName()).isEqualTo((Object)"Russell Crowe");
        this.em.remove((Object)firstActor);
        secondActor = (Actor)this.em.find(Actor.class, (Object)secondActor.getId());
        Assertions.assertThat((Object)secondActor).isNotNull();
        Assertions.assertThat((Long)secondActor.getId()).isEqualTo(2L);
        Assertions.assertThat((String)secondActor.getName()).isEqualTo((Object)"Johnny Depp");
        this.em.remove((Object)secondActor);
        this.em.getTransaction().commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Song.class, Actor.class};
    }
}

