/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import java.util.Arrays;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.ogm.backendtck.id.TestNextValueGeneration;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.id.impl.OgmSequenceGenerator;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.Test;

public class SequenceNextValueGenerationTest
extends TestNextValueGeneration {
    private static final String INITIAL_VALUE_SEQUENCE = "InitialValueSequence";
    private static final String THREAD_SAFETY_SEQUENCE = "ThreadSafetySequence";
    private static final int INITIAL_VALUE_TEST_FIRST_VALUE = 5;
    private static final int THREAD_SAFETY_FIRST_VALUE = 12;
    private static final int THREAD_SAFETY_INCREMENT = 3;

    @Override
    protected IdSourceKey buildIdGeneratorKey(Class<?> entityClass, String sequenceName) {
        IdentifierGenerator metadata = this.generateKeyMetadata(entityClass);
        IdSourceKeyMetadata sequenceMetadata = ((OgmSequenceGenerator)metadata).getGeneratorKeyMetadata();
        if (this.dialect.supportsSequences()) {
            return IdSourceKey.forSequence((IdSourceKeyMetadata)sequenceMetadata);
        }
        return IdSourceKey.forTable((IdSourceKeyMetadata)sequenceMetadata, (String)sequenceName);
    }

    @Test
    public void testFirstValueIsInitialValue() {
        IdSourceKey generatorKey = this.buildIdGeneratorKey(InitialValueEntity.class, INITIAL_VALUE_SEQUENCE);
        Number sequenceValue = this.dialect.nextValue(new NextValueRequest(generatorKey, 1, 5));
        Assertions.assertThat((long)sequenceValue.longValue()).isEqualTo((Object)5L);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.INFINISPAN})
    public void testIncrements() throws InterruptedException {
        IdSourceKey generatorKey = this.buildIdGeneratorKey(ThreadSafetyEntity.class, THREAD_SAFETY_SEQUENCE);
        NextValueRequest nextValueRequest = new NextValueRequest(generatorKey, 3, 12);
        TestNextValueGeneration.IncrementJob[] runJobs = this.runJobs(nextValueRequest);
        int[] allGeneratedValues = new int[INCREASES_PER_TASK * NUMBER_OF_TASKS];
        int i = 0;
        for (TestNextValueGeneration.IncrementJob job : runJobs) {
            int[] generatedValuesPerJob;
            for (int generatedValue : generatedValuesPerJob = job.retrieveAllGeneratedValues()) {
                allGeneratedValues[i++] = generatedValue;
            }
        }
        Arrays.sort(allGeneratedValues);
        int expectedValue = 12;
        for (int k = 0; k < allGeneratedValues.length; ++k) {
            ((IntAssert)Assertions.assertThat((int)allGeneratedValues[k]).as("Unexpected value generated, index: " + k)).isEqualTo(expectedValue);
            expectedValue += 3;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{InitialValueEntity.class, ThreadSafetyEntity.class};
    }

    @Entity
    @Table(name="THREAD_SAFETY_GENERATOR_SEQUENCE")
    private static class ThreadSafetyEntity {
        @Id
        @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="gen2")
        @SequenceGenerator(name="gen2", sequenceName="ThreadSafetySequence", initialValue=12)
        Long id;

        private ThreadSafetyEntity() {
        }
    }

    @Entity
    @Table(name="INITIAL_VALUE_GENERATOR_SEQUENCE")
    private static class InitialValueEntity {
        @Id
        @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="gen1")
        @SequenceGenerator(name="gen1", sequenceName="InitialValueSequence", initialValue=5)
        Long id;

        private InitialValueEntity() {
        }
    }
}

