/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.backendtck.id.Composer;
import org.hibernate.ogm.backendtck.id.Music;
import org.hibernate.ogm.backendtck.id.Video;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TableIdGeneratorTest
extends OgmJpaTestCase {
    private EntityManager em;

    @Before
    public void setUp() {
        this.em = this.getFactory().createEntityManager();
    }

    @After
    public void tearDown() {
        this.em.close();
    }

    @Test
    public void testTableIdGenerator() throws Exception {
        this.em.getTransaction().begin();
        Music music = new Music();
        music.setName("Variations Sur Marilou");
        music.setComposer("Gainsbourg");
        this.em.persist((Object)music);
        Video video = new Video();
        video.setDirector("Wes Craven");
        video.setName("Scream");
        this.em.persist((Object)video);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        music = (Music)this.em.find(Music.class, (Object)music.getId());
        Assertions.assertThat((Object)music).isNotNull();
        Assertions.assertThat((String)music.getName()).isEqualTo((Object)"Variations Sur Marilou");
        this.em.remove((Object)music);
        video = (Video)this.em.find(Video.class, (Object)video.getId());
        Assertions.assertThat((Object)video).isNotNull();
        Assertions.assertThat((String)video.getName()).isEqualTo((Object)"Scream");
        this.em.remove((Object)video);
        this.em.getTransaction().commit();
    }

    @Test
    public void testTableIdGeneratorUsingLong() throws Exception {
        this.em.getTransaction().begin();
        Composer composer = new Composer();
        composer.setName("Gainsbourg");
        this.em.persist((Object)composer);
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        composer = (Composer)this.em.find(Composer.class, (Object)composer.getId());
        Assertions.assertThat((Object)composer).isNotNull();
        Assertions.assertThat((String)composer.getName()).isEqualTo((Object)"Gainsbourg");
        Assertions.assertThat((Long)composer.getId()).isEqualTo(Integer.MIN_VALUE);
        this.em.remove((Object)composer);
        this.em.getTransaction().commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Music.class, Video.class, Composer.class};
    }
}

