/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import java.util.Arrays;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.ogm.backendtck.id.TestNextValueGeneration;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.id.impl.OgmTableGenerator;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.utils.GridDialectType;
import org.hibernate.ogm.utils.SkipByGridDialect;
import org.junit.Test;

public class TableNextValueGenerationTest
extends TestNextValueGeneration {
    private static final String INITIAL_VALUE_SEQUENCE = "InitialValueSequence";
    private static final String THREAD_SAFETY_SEQUENCE = "ThreadSafetySequence";
    private static final int INITIAL_VALUE_TEST_FIRST_VALUE = 5;
    private static final int THREAD_SAFETY_FIRST_VALUE = 12;
    private static final int THREAD_SAFETY_INCREMENT = 3;

    @Override
    protected IdSourceKey buildIdGeneratorKey(Class<?> entityClass, String sequenceName) {
        IdentifierGenerator metadata = this.generateKeyMetadata(entityClass);
        IdSourceKeyMetadata tableMetadata = ((OgmTableGenerator)metadata).getGeneratorKeyMetadata();
        return IdSourceKey.forTable((IdSourceKeyMetadata)tableMetadata, (String)sequenceName);
    }

    @Test
    public void testFirstValueIsInitialValue() {
        IdSourceKey generatorKey = this.buildIdGeneratorKey(InitialValueEntity.class, INITIAL_VALUE_SEQUENCE);
        Number sequenceValue = this.dialect.nextValue(new NextValueRequest(generatorKey, 1, 5));
        Assertions.assertThat((long)sequenceValue.longValue()).isEqualTo((Object)5L);
    }

    @Test
    @SkipByGridDialect(value={GridDialectType.INFINISPAN})
    public void testIncrements() throws InterruptedException {
        IdSourceKey generatorKey = this.buildIdGeneratorKey(ThreadSafetyEntity.class, THREAD_SAFETY_SEQUENCE);
        NextValueRequest nextValueRequest = new NextValueRequest(generatorKey, 3, 12);
        TestNextValueGeneration.IncrementJob[] runJobs = this.runJobs(nextValueRequest);
        int[] allGeneratedValues = new int[INCREASES_PER_TASK * NUMBER_OF_TASKS];
        int i = 0;
        for (TestNextValueGeneration.IncrementJob job : runJobs) {
            int[] generatedValuesPerJob;
            for (int generatedValue : generatedValuesPerJob = job.retrieveAllGeneratedValues()) {
                allGeneratedValues[i++] = generatedValue;
            }
        }
        Arrays.sort(allGeneratedValues);
        int expectedValue = 12;
        for (int generatedValue : allGeneratedValues) {
            ((IntAssert)Assertions.assertThat((int)generatedValue).as("Unexpected value generated")).isEqualTo(expectedValue);
            expectedValue += 3;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{InitialValueEntity.class, ThreadSafetyEntity.class};
    }

    @Entity
    @Table(name="THREAD_SAFETY_GENERATOR_TABLE")
    private static class ThreadSafetyEntity {
        @Id
        @GeneratedValue(strategy=GenerationType.TABLE, generator="gen2")
        @TableGenerator(name="gen2", initialValue=12, pkColumnValue="ThreadSafetySequence")
        Long id;

        private ThreadSafetyEntity() {
        }
    }

    @Entity
    @Table(name="INITIAL_VALUE_GENERATOR_TABLE")
    private static class InitialValueEntity {
        @Id
        @GeneratedValue(strategy=GenerationType.TABLE, generator="gen1")
        @TableGenerator(name="gen1", initialValue=5, pkColumnValue="InitialValueSequence")
        Long id;

        private InitialValueEntity() {
        }
    }
}

