/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.utils.jpa.OgmJpaTestCase;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.junit.Before;

public abstract class TestNextValueGeneration
extends OgmJpaTestCase {
    protected static boolean RUN_FULL_TESTS = Boolean.getBoolean("ogm.runFullStressTests");
    protected static int PARALLEL_THREADS = Runtime.getRuntime().availableProcessors();
    protected static int NUMBER_OF_TASKS = PARALLEL_THREADS * 3;
    protected static int INCREASES_PER_TASK = RUN_FULL_TESTS ? 100000 : 10;
    protected GridDialect dialect;

    @Before
    public void setUp() {
        ServiceRegistryImplementor serviceRegistry = this.getServiceRegistry();
        this.dialect = (GridDialect)serviceRegistry.getService(GridDialect.class);
    }

    protected IncrementJob[] runJobs(NextValueRequest nextValueRequest) throws InterruptedException {
        int i;
        ExecutorService executorService = Executors.newWorkStealingPool(PARALLEL_THREADS);
        IncrementJob[] runJobs = new IncrementJob[NUMBER_OF_TASKS];
        System.out.println("Starting stress tests on " + PARALLEL_THREADS + " Threads running " + NUMBER_OF_TASKS + " tasks");
        for (i = 0; i < NUMBER_OF_TASKS; ++i) {
            runJobs[i] = new IncrementJob(this.dialect, nextValueRequest);
        }
        for (i = 0; i < NUMBER_OF_TASKS; ++i) {
            executorService.execute(runJobs[i]);
        }
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.MINUTES);
        return runJobs;
    }

    protected abstract IdSourceKey buildIdGeneratorKey(Class<?> var1, String var2);

    protected IdentifierGenerator generateKeyMetadata(Class<?> entityClass) {
        OgmEntityManagerFactory emFactory = (OgmEntityManagerFactory)this.getFactory();
        SessionFactoryImplementor sessionFactory = emFactory.getSessionFactory();
        IdentifierGenerator generator = sessionFactory.getIdentifierGenerator(entityClass.getName());
        return generator;
    }

    protected static class IncrementJob
    implements Runnable {
        private final GridDialect dialect;
        private final NextValueRequest nextValueRequest;
        private final int[] generatedValues = new int[INCREASES_PER_TASK];

        private IncrementJob(GridDialect dialect, NextValueRequest nextValueRequest) {
            this.nextValueRequest = nextValueRequest;
            this.dialect = dialect;
        }

        @Override
        public void run() {
            for (int i = 0; i < INCREASES_PER_TASK; ++i) {
                this.recordValue(i, this.dialect.nextValue(this.nextValueRequest));
            }
        }

        private synchronized void recordValue(int i, Number sequenceValue) {
            this.generatedValues[i] = sequenceValue.intValue();
        }

        protected synchronized int[] retrieveAllGeneratedValues() {
            return this.generatedValues;
        }
    }
}

