/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.backendtck.id.embeddable;

import java.util.List;
import org.fest.assertions.Assertions;
import org.hibernate.Transaction;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.backendtck.id.embeddable.SingleBoardComputer;
import org.hibernate.ogm.backendtck.id.embeddable.SingleBoardComputerPk;
import org.hibernate.ogm.utils.OgmTestCase;
import org.junit.Test;

public class EmbeddableIdTest
extends OgmTestCase {
    @Test
    public void canRetrieveListOfEntityWithSingleColumnEmbeddableId() throws Exception {
        OgmSession session = this.openSession();
        Transaction transaction = session.beginTransaction();
        session.persist((Object)new SingleBoardComputer(new SingleBoardComputerPk("sbc-1"), "Raspberry Pi"));
        session.persist((Object)new SingleBoardComputer(new SingleBoardComputerPk("sbc-2"), "BeagleBone"));
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        List computers = session.createQuery("From SingleBoardComputer").list();
        Assertions.assertThat((List)computers).onProperty("name").containsOnly(new Object[]{"Raspberry Pi", "BeagleBone"});
        for (SingleBoardComputer sbc : computers) {
            session.delete((Object)sbc);
        }
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{SingleBoardComputer.class};
    }
}

